(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    113700,       2278]
NotebookOptionsPosition[    111035,       2223]
NotebookOutlinePosition[    111368,       2238]
CellTagsIndexPosition[    111325,       2235]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"docpath", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "quest", ",", "answer", ",", "vari", ",", "valor", ",", "resp", ",", "n", 
    ",", "substituicoes", ",", "\[Alpha]", ",", " ", "\[Beta]", ",", 
    "\[Gamma]"}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "script2", "=", 
   "\"\<<script type=\\\"text/javascript\\\"\n\
src=\\\"https://c328740.ssl.cf1.rackcdn.com/mathjax/latest/MathJax.js?config=\
TeX-AMS-MML_HTMLorMML\\\"> \n</script>\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "script", "=", 
   "\"\<<script type=\\\"text/javascript\\\"\n\
src=\\\"http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_\
HTMLorMML\\\">\[IndentingNewLine]</script>\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "http", "=", "\"\<http://hostel.ufabc.edu.br/~daniel.miranda/t-img/\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"url", "[", "imgp_", "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"http", "<>", "imgp"}]}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"url", "[", "\"\<gato.jpg\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FiguraLatex", "[", "imgp_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"StringQ", "[", "imgp", "]"}], ",", 
     RowBox[{
     "\"\<\\\\includegraphics[width=3.3cm]{./imagens/\>\"", "<>", "imgp", " ",
       "<>", "\"\<}\>\""}], ",", "\"\<\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FiguraHtml", "[", "imgp_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"StringQ", "[", "imgp", "]"}], ",", 
     RowBox[{"\"\<<img src=\\\"\>\"", "<>", 
      RowBox[{"url", "[", "imgp", "]"}], " ", "<>", "\"\<\\\" alt=\\\"\>\"", "<>", 
      RowBox[{"url", "[", "imgp", "]"}], " ", "<>", 
      "\"\<\\\"  width=\\\"170\\\">\>\""}], ",", "\"\<\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Scripdisable", "=", "F"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"Scripdisable", "\[Equal]", "F"}], ",", 
    RowBox[{"script", "=", "\"\<\>\""}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Change", "[", "x_", "]"}], ":=", 
  RowBox[{"Hold", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "=", 
        RowBox[{"Evaluate", "[", "x", "]"}]}], ",", "id"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"a", "===", "V"}], ",", "F", ",", "V"}], "]"}]}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Gera", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"quest", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<Q\>\"", "<>", 
         RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"answer", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<Ans\>\"", "<>", 
         RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"vari", "=", 
       RowBox[{"ToExpression", "[", 
        RowBox[{"\"\<valor\>\"", "<>", 
         RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"quest", ",", "answer"}], "}"}], ",", 
      RowBox[{"Evaluate", "[", " ", 
       RowBox[{"vari", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
      RowBox[{"Evaluate", "[", " ", 
       RowBox[{"vari", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
      RowBox[{"Evaluate", "[", " ", 
       RowBox[{"vari", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Concatenate", "[", "list_", "]"}], ":=", 
  RowBox[{"StringJoin", "[", "list", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Cat", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "x", "]"}], ">", "0"}], ",", 
    RowBox[{"Hold", "[", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"string", "=", "\"\<\>\""}], "}"}], ",", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", 
           RowBox[{"Length", "[", "x", "]"}]}], ",", 
          RowBox[{"i", "++"}], ",", 
          RowBox[{"string", "=", 
           RowBox[{"string", "<>", 
            RowBox[{"StringReplace", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{"x", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"\"\<\\n\>\"", "\[Rule]", "\"\<\>\""}], "}"}]}], 
             "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", "string"}]}], 
      "]"}], "]"}], ",", "x"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"permut", "=", 
   RowBox[{"Permutations", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Certa", "[", "x_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "=", "x"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"a", "==", "1"}], ",", "\"\<*\>\"", ",", "\"\< \>\""}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CertaM", "[", "x_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "=", "x"}], "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"a", "==", "1"}], ",", "\"\<= \>\"", ",", "\"\<~\>\""}], 
      "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Certa2", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "=", "x"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Position", "[", 
       RowBox[{"x", ",", "1"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "\"\<A\>\""}], ",", 
       RowBox[{"2", "\[Rule]", "\"\<B\>\""}], ",", 
       RowBox[{"3", "\[Rule]", "\"\<C\>\""}], ",", 
       RowBox[{"4", "\[Rule]", "\"\<D\>\""}], ",", 
       RowBox[{"5", "\[Rule]", "\"\<E\>\""}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"oq", ":=", 
   RowBox[{"RandomChoice", "[", "permut", "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GeraMoodle", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"quest", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Q\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"answer", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Ans\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"vari", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<valor\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"fig", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Imag\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"oq", "=", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"RandomChoice", "[", "permut", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{"ReleaseHold", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"Cat", "[", 
             RowBox[{"ReleaseHold", "[", "quest", "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\>\"", "<>", 
         RowBox[{"FiguraHtml", "[", "fig", "]"}], "<>", "\"\< {\\n\>\"", 
         "\[IndentingNewLine]", "<>", "\"\<\\n\>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "\[IndentingNewLine]", "<>", "\"\<\\) \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<\\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n}\>\"", "<>", "\"\<\\n\>\""}]}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GeraAiken", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"quest", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Q\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"answer", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Ans\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"vari", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<valor\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"fig", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Imag\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"oq", "=", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"RandomChoice", "[", "permut", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"oqa", "=", "oq"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{"ReleaseHold", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"Cat", "[", 
             RowBox[{"ReleaseHold", "[", "quest", "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\n\>\"", "\[IndentingNewLine]", "<>", 
         "\"\< \\n\>\"", "<>", "\"\<A. \\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n\>\"", "<>", "\"\<B. \\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "\[IndentingNewLine]", "<>", "\"\<\\) \\n\>\"", "<>", 
         "\"\<C. \\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n\>\"", "<>", "\"\<D. \\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n\>\"", "<>", "\"\<E. \\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n\>\"", "<>", "\[IndentingNewLine]", 
         "\"\<ANSWER:\>\"", "<>", 
         RowBox[{"Certa2", "[", "oqa", "]"}], "<>", "\"\<\\n \\n\>\""}]}], 
       ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "]"}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GeraL", "[", "n_", "]"}], ":=", 
   RowBox[{"Replace", "[", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"quest", "=", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<Q\>\"", "<>", 
            RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"answer", "=", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<Ans\>\"", "<>", 
            RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"vari", "=", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<valor\>\"", "<>", 
            RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"fig", "=", 
          RowBox[{"ToExpression", "[", 
           RowBox[{"\"\<Imag\>\"", "<>", 
            RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"\"\<\\\\Exercise \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"ReleaseHold", "[", 
             RowBox[{"ReleaseHold", "[", 
              RowBox[{"Cat", "[", 
               RowBox[{"ReleaseHold", "[", "quest", "]"}], "]"}], "]"}], 
             "]"}], "]"}], "]"}], "\[IndentingNewLine]", "<>", "\"\<\\n\>\"", 
          "<>", 
          RowBox[{"FiguraLatex", "[", "fig", "]"}], "<>", 
          "\[IndentingNewLine]", "\"\<\>\"", "<>", "\"\<\\\\Question $\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ReleaseHold", "[", 
             RowBox[{"answer", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], "<>", 
          "\"\<$ \\n\>\"", "<>", "\"\<\\\\Question $\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ReleaseHold", "[", 
             RowBox[{"answer", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], "]"}], 
          "\[IndentingNewLine]", "<>", "\"\<$ \\n\>\"", "<>", 
          "\"\<\\\\Question $\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ReleaseHold", "[", 
             RowBox[{"answer", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], "]"}], "<>", 
          "\"\<$ \\n\>\"", "<>", "\"\<\\\\Question $\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ReleaseHold", "[", 
             RowBox[{"answer", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}], "]"}], "]"}], "<>", 
          "\"\<$ \\n\>\"", "<>", "\"\<\\\\Question $\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ReleaseHold", "[", 
             RowBox[{"answer", "[", 
              RowBox[{"[", "5", "]"}], "]"}], "]"}], "]"}], "]"}], "<>", 
          "\"\<$ \\n\>\"", "<>", "\"\<\\n\>\""}], ",", 
         RowBox[{"Evaluate", "[", " ", 
          RowBox[{"vari", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
         RowBox[{"Evaluate", "[", " ", 
          RowBox[{"vari", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
         RowBox[{"Evaluate", "[", " ", 
          RowBox[{"vari", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "]"}]}], "]"}], ",", 
     
     RowBox[{"\"\<$$\>\"", "\[Rule]", "\"\<$\>\""}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GeraGIFT", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"quest", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Q\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"answer", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Ans\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"vari", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<valor\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"fig", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Imag\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"oq", "=", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"RandomChoice", "[", "permut", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{"ReleaseHold", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"Cat", "[", 
             RowBox[{"ReleaseHold", "[", "quest", "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\>\"", "<>", 
         RowBox[{"FiguraHtml", "[", "fig", "]"}], "<>", "\"\< {\>\"", 
         "\[IndentingNewLine]", "<>", "\"\<\\n\>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\)\\n \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "\[IndentingNewLine]", "<>", "\"\<\\)\\n \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\)\\n \>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "4", "]"}], "]"}], "]"}], "<>", "\"\<\\(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n\>\"", "<>", 
         RowBox[{"CertaM", "[", 
          RowBox[{"oq", "[", 
           RowBox[{"[", "5", "]"}], "]"}], "]"}], "<>", "\"\< \\(\>\"", "<>", 
         
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"answer", "[", 
             RowBox[{"[", 
              RowBox[{"oq", "[", 
               RowBox[{"[", "5", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", "\"\<\\) \\n}\>\"", "<>", "\"\<\\n\>\""}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "1", "]"}], "]"}], " ", "]"}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
       RowBox[{"Evaluate", "[", " ", 
        RowBox[{"vari", "[", 
         RowBox[{"[", "3", "]"}], "]"}], " ", "]"}]}], "\[IndentingNewLine]", 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Escreve", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"quest", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Q\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"answer", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Ans\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"vari", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<valor\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"print", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{
          RowBox[{"GeraF", "[", "n", "]"}], ",", "2"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"WriteString", "[", 
        RowBox[{"saida", ",", 
         RowBox[{"print", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "print", "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExportarMoodle", "[", "lista_", "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"quallista", "=", "lista"}], ";", "\[IndentingNewLine]", 
      RowBox[{"SetDirectory", "[", 
       RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"docpath", "=", 
       RowBox[{"ToFileName", "[", 
        RowBox[{"SetDirectory", "[", 
         RowBox[{"NotebookDirectory", "[", "]"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"nb", "=", 
       RowBox[{"NotebookOpen", "[", 
        RowBox[{"docpath", "<>", "quallista", "<>", "\"\<.nb\>\""}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", 
       RowBox[{
       "quest", ",", "answer", ",", "vari", ",", "valor", ",", "resp", ",", 
        "n", ",", "substituicoes", ",", "\[Alpha]", ",", " ", "\[Beta]", ",", 
        "\[Gamma]"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"NotebookEvaluate", "[", "nb", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"CreateDirectory", "[", "quallista", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"docpath2", "=", 
       RowBox[{"SetDirectory", "[", "quallista", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Questoes", "=", 
       RowBox[{"Length", "[", "Quest", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"o", "=", "1"}], ",", 
        RowBox[{"o", "<=", "Questoes"}], ",", 
        RowBox[{"o", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"imp", "=", 
          RowBox[{"Quest", "[", 
           RowBox[{"[", "o", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"lo", "=", 
          RowBox[{"Length", "[", "imp", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"saidasl", "=", 
          RowBox[{"FileNameJoin", "[", 
           RowBox[{"{", 
            RowBox[{"docpath2", ",", 
             RowBox[{"quallista", "<>", "\"\<Q\>\"", "<>", 
              RowBox[{"ToString", "[", "o", "]"}], "<>", 
              "\"\<Total.txt\>\""}]}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"OpenWrite", "[", 
          RowBox[{"saidasl", ",", 
           RowBox[{
           "CharacterEncoding", " ", "\[Rule]", " ", "\"\<UTF8\>\""}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "o", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"k", "=", "1"}], ",", 
           RowBox[{"k", "<=", "lo"}], ",", 
           RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"print", "=", 
               RowBox[{"Flatten", "[", 
                RowBox[{
                 RowBox[{"GeraAiken", "[", 
                  RowBox[{"imp", "[", 
                   RowBox[{"[", "k", "]"}], "]"}], "]"}], ",", "2"}], "]"}]}],
               "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"WriteString", "[", 
                RowBox[{"saidasl", ",", 
                 RowBox[{"print", "[", 
                  RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"j", ",", "1", ",", 
                 RowBox[{"Length", "[", "print", "]"}]}], "}"}]}], "]"}]}], 
            "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Close", "[", "saidasl", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetDirectory", "[", 
       RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"TrocarCifrao2", "[", "arquivo_", "]"}], ":=", 
       RowBox[{"Module", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "g"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"SetDirectory", "[", 
           RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"nb", "=", 
           RowBox[{"NotebookOpen", "[", 
            RowBox[{"docpath", "<>", "quallista", "<>", "\"\<.nb\>\""}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Clear", "[", 
           RowBox[{
           "quest", ",", "answer", ",", "vari", ",", "valor", ",", "resp", 
            ",", "n", ",", "substituicoes", ",", "\[Alpha]", ",", " ", 
            "\[Beta]", ",", "\[Gamma]"}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"NotebookEvaluate", "[", "nb", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Questoes", "=", 
           RowBox[{"Length", "[", "Quest", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"docpath2", "=", 
           RowBox[{"SetDirectory", "[", "arquivo", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"o", "=", "1"}], ",", 
            RowBox[{"o", "<=", "Questoes"}], ",", 
            RowBox[{"o", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"saidasl", "=", 
              RowBox[{"FileNameJoin", "[", 
               RowBox[{"{", 
                RowBox[{"docpath2", ",", 
                 RowBox[{"quallista", "<>", "\"\<Q\>\"", "<>", 
                  RowBox[{"ToString", "[", "o", "]"}], "<>", 
                  "\"\<Total.txt\>\""}]}], "}"}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"a", "=", 
              RowBox[{"Import", "[", 
               RowBox[{"saidasl", ",", "\"\<String\>\""}], "]"}]}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"OpenWrite", "[", 
              RowBox[{"saidasl", ",", 
               RowBox[{
               "CharacterEncoding", "\[Rule]", "\"\<ISO8859-15\>\""}]}], 
              "]"}], ";", "\[IndentingNewLine]", 
             RowBox[{"g", "=", 
              RowBox[{"StringReplace", "[", 
               RowBox[{"a", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                  "\"\<\\\\lesssim\>\"", "\[Rule]", "\"\<\\\\lt\>\""}], ",", 
                  " ", 
                  RowBox[{"\"\<\\\\gtrsin\>\"", "\[Rule]", "\"\<\\\\gt\>\""}],
                   ",", 
                  RowBox[{
                  "\"\<\\\\lor\>\"", "\[Rule]", "\"\<\\\\text{ ou }\>\""}], 
                  ",", " ", 
                  RowBox[{
                  "\"\<\\\\land\>\"", "\[Rule]", "\"\<\\\\text{ e }\>\""}], 
                  ",", 
                  RowBox[{
                  "\"\<\\\\left\\\\left\>\"", "\[Rule]", "\"\<\\\\left\>\""}],
                   ",", 
                  RowBox[{
                  "\"\<\\\\right\\\\right\>\"", "\[Rule]", 
                   "\"\<\\\\right\>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\int\>\"", "\[Rule]", 
                   "\"\<\\\\displaystyle\\\\int\>\""}], ",", " ", 
                  RowBox[{"\"\<{\\\\' a}\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
                  
                  RowBox[{"\"\<{\\\\~ a}\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
                  
                  RowBox[{"\"\<{\\\\' \\\\i}\>\"", "\[Rule]", "\"\<i\>\""}], 
                  ",", 
                  RowBox[{"\"\<\\\\otimes\>\"", "\[Rule]", "\"\<\>\""}], ",", 
                  
                  RowBox[{
                  "\"\<\\\\tan ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arctan}\>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\cot ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arccotan}\>\""}], ",", " ", 
                  RowBox[{
                  "\"\<\\\\sin ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arcsen}\>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\cos ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arccos}\>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\sec ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arcsec}\>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\csc ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arccossec}\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                  "\"\<\\\\sinh ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arcsenh} \>\""}], ",", " ", 
                  RowBox[{
                  "\"\<\\\\loga\>\"", "\[Rule]", "\"\<\\\\textrm{log}\>\""}], 
                  ",", "  ", 
                  RowBox[{
                  "\"\<\\\\log\>\"", "\[Rule]", "\"\<\\\\textrm{ln} \>\""}], 
                  ",", 
                  RowBox[{
                  "\"\<\\\\oplus\>\"", "\[Rule]", "\"\<\\\\text{ e }\>\""}], 
                  ",", " ", 
                  RowBox[{"\"\<</br>\>\"", "\[Rule]", "\"\<\\n\>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\sinh\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{senh} \>\""}], ",", 
                  RowBox[{
                  "\"\<\\\\sin\>\"", "\[Rule]", "\"\<\\\\textrm{sen} \>\""}], 
                  " ", ",", 
                  RowBox[{
                  "\"\<\\\\tanh ^{-1}\>\"", "\[Rule]", 
                   "\"\<\\\\textrm{arctanh} \>\""}], ",", 
                  RowBox[{"\"\<</br>\>\"", "\[Rule]", "\"\<\\n\>\""}], ",", 
                  RowBox[{"\"\<,\\\\]\\\\}\>\"", "\[Rule]", "\"\<]\>\""}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<,\\\\)\\\\}\>\"", "\[Rule]", "\"\<\\\\)\>\""}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<\\\\{\\\\(,\>\"", "\[Rule]", "\"\<\\\\(\>\""}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<\\\\{\\\\[,\>\"", "\[Rule]", "\"\<\\\\[\>\""}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<\\\\{(,\>\"", "\[Rule]", "\"\<(\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<\\\\{[,\>\"", "\[Rule]", "\"\<[\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<,]\\\\}\>\"", "\[Rule]", " ", "\"\<]\>\""}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<,)\\\\}\>\"", "\[Rule]", " ", "\"\<)\>\""}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"\"\<>\>\"", "\[Rule]", "\"\<\\\\gt\>\""}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{"\"\<<\>\"", "\[Rule]", " ", "\"\<\\\\lt\>\""}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{
                  "\"\<\[Rule]\>\"", "\[Rule]", " ", 
                   "\"\<\\(\\\\Longrightarrow\\)\>\""}]}], 
                 "\[IndentingNewLine]", "}"}]}], "]"}]}], ";", 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"WriteString", "[", 
              RowBox[{"saidasl", ",", "g"}], "]"}], ";", 
             "\[IndentingNewLine]", 
             RowBox[{"Close", "[", "saidasl", "]"}], ";"}]}], "]"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"TrocarCifrao2", "[", "quallista", "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ExportarLaTeX", "[", "lista_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"quallista", "=", "lista"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variacao", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variacao2", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"variacao3", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"nb", "=", 
       RowBox[{"NotebookOpen", "[", 
        RowBox[{"docpath", "<>", "quallista", "<>", "\"\<.nb\>\""}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", 
       RowBox[{
       "a", ",", "b", ",", "x", ",", "y", ",", "Quest", ",", "quest", ",", 
        "answer", ",", "vari", ",", "valor", ",", "resp", ",", "n", ",", 
        "substituicoes", ",", "\[Alpha]", ",", " ", "\[Beta]", ",", 
        "\[Gamma]", ",", "questao1", ",", "questao2", ",", "questao3", ",", 
        "questao4", ",", "questao5", ",", "questao6", ",", "questao7", ",", 
        "questao8", ",", "questao9", ",", "questao10", ",", "questao11", ",", 
        "questao12", ",", "questao13", ",", "titulo", ",", "assuntos"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", 
       RowBox[{
       "\"\<exp*\>\"", ",", "\"\<Q1*\>\"", ",", "\"\<Q2*\>\"", ",", 
        "\"\<Q3*\>\"", ",", "\"\<Q4*\>\"", ",", "\"\<Q5*\>\"", ",", 
        "\"\<valor*\>\"", ",", "\"\<Ans*\>\""}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"NotebookEvaluate", "[", "nb", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Questoes", "=", 
       RowBox[{"Length", "[", "Quest", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"saidasl", "=", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"docpath2", ",", 
          RowBox[{
          "quallista", "<>", "\"\<\>\"", "<>", "\"\<Total.tex\>\""}]}], "}"}],
         "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"OpenWrite", "[", 
       RowBox[{"saidasl", ",", 
        RowBox[{"CharacterEncoding", "\[Rule]", "\"\<ISO8859-15\>\""}]}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"saidasl", ",", 
        RowBox[{
        "\"\<\\\\documentclass[a4paper,11pt]{scrartcl}\n \\n \
\\\\usepackage{multicol}\n\\\\addtolength{\\\\parindent}{-0.4cm} \\n\n\
\\\\setlength{\\\\topmargin}{-0.9cm}\\n\n\\\\setlength{\\\\headsep}{ -.1in} \
\\n\n\\\\setlength{\\\\textheight}{24.4cm}\\n\n\
\\\\setlength{\\\\textwidth}{18.7cm}\\n\n\
\\\\setlength{\\\\oddsidemargin}{-0.6in}\\n\n\
\\\\setlength{\\\\evensidemargin}{-0.6in}\\n\n\
\\\\setlength{\\\\marginparwidth}{ -40pt}\n\\\\setlength{\\\\marginparsep}{ \
-10pt}\n\\\\usepackage{beramono,euler,eulervm}\n\\\\usepackage{exercise} \\n \
\\\\usepackage[latin1]{inputenc} \\n \\\\usepackage{mathtools} \\n \
\\\\begin{document} \\n  \\\\begin{center} \\\\Huge \>\"", " ", "<>", 
         "titulo", "<>", " ", 
         "\"\<\\\\end{center}  \\\\vspace{1cm} \n\\\\textbf{Assuntos: }\>\"", 
         "<>", "assuntos", "<>", 
         "\"\<\\\\vspace{0.5cm}  \\\\begin{multicols}{2} \
\\\\begin{ExerciseList}\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"o", "=", "1"}], ",", 
        RowBox[{"o", "<=", "Questoes"}], ",", 
        RowBox[{"o", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"imp", "=", 
          RowBox[{"Quest", "[", 
           RowBox[{"[", "o", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"lo", "=", 
          RowBox[{"Length", "[", "imp", "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "o", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"varquest", "=", 
          RowBox[{"varquest", "+", 
           RowBox[{"Length", "[", "imp", "]"}]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"WriteString", "[", 
          RowBox[{"saidasl", ",", 
           RowBox[{"\"\<\\\\subsection*{Quest\[ATilde]o \>\"", "<>", 
            RowBox[{"ToString", "[", "o", "]"}], "<>", "\"\<}\>\""}]}], "]"}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"variacao4", "=", "0"}], ";", "\[IndentingNewLine]", 
         RowBox[{"variacao", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"Flatten", "[", "Quest", "]"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"k", "=", "1"}], ",", 
           RowBox[{"k", "\[LessEqual]", "lo"}], ",", 
           RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", "al", "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"print", "=", 
                RowBox[{"Flatten", "[", 
                 RowBox[{
                  RowBox[{"Evaluate", "[", 
                   RowBox[{"GeraL", "[", 
                    RowBox[{"imp", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "]"}], "]"}], ",", "2"}], 
                 "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"comp", "=", 
                RowBox[{"Evaluate", "[", 
                 RowBox[{"Length", "[", 
                  RowBox[{"Flatten", "[", 
                   RowBox[{
                    RowBox[{"GeraL", "[", 
                    RowBox[{"imp", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "]"}], ",", "2"}], "]"}], 
                  "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"WriteString", "[", 
                    RowBox[{"saidasl", ",", 
                    RowBox[{"print", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}], 
                   "]"}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"al", "=", 
                   RowBox[{"RandomInteger", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "print", "]"}]}], "}"}], "]"}]}], 
                  ";", 
                  RowBox[{"WriteString", "[", 
                   RowBox[{"saidasl", ",", 
                    RowBox[{"print", "[", 
                    RowBox[{"[", "al", "]"}], "]"}]}], "]"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"j", ",", "1", ",", "1"}], "}"}]}], 
                "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
               RowBox[{"variacao2", "=", 
                RowBox[{"(", 
                 RowBox[{"variacao2", "+", "comp"}], ")"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"variacao4", "=", 
                RowBox[{"(", 
                 RowBox[{"variacao4", "+", "comp"}], ")"}]}], ";", 
               "\[IndentingNewLine]", 
               RowBox[{"varia", "=", "False"}], ";", "\[IndentingNewLine]", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"varia", "\[Equal]", "True"}], ",", 
                 RowBox[{"WriteString", "[", 
                  RowBox[{"saidasl", ",", 
                   RowBox[{
                   "\"\<\\n \\\\vspace{0.5cm} \\\\textbf{Varia\[CCedilla]\
\[OTilde]es:} \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"ScientificForm", "[", 
                    RowBox[{"Length", "[", "print", "]"}], "]"}], "]"}], 
                    "<>", "\"\<\\n \\\\vspace{0.5cm}\>\""}]}], "]"}]}], 
                "]"}]}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"variacao3", "=", 
          RowBox[{"Evaluate", "[", 
           RowBox[{"variacao3", "*", "variacao4"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Print", "[", "variacao3", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"prob", "=", 
          RowBox[{"ScientificForm", "[", 
           RowBox[{"N", "[", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"Product", "[", 
                RowBox[{
                 RowBox[{"variacao3", "-", "i"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "1", ",", "1500"}], "}"}]}], "]"}], "/", 
               RowBox[{"Product", "[", 
                RowBox[{"variacao3", ",", 
                 RowBox[{"{", 
                  RowBox[{"i", ",", "1", ",", "1500"}], "}"}]}], "]"}]}]}], 
             ",", "3"}], "]"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", 
       RowBox[{"saidasl", ",", 
        RowBox[{
        "\"\<\\n \\\\vspace{0.5cm} \\\\hrule \\n \\\\vspace{0.2cm} \
\\\\textbf{N\[UAcute]mero Total de Quest\[OTilde]es:} $$\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ScientificForm", "[", "variacao", "]"}], "]"}], "]"}], 
         "<>", "\"\<$$ \\n \\n \\\\textbf{N\[UAcute]mero Total de Varia\
\[CCedilla]\[OTilde]es:} $$\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ScientificForm", "[", "variacao2", "]"}], "]"}], "]"}], 
         "<>", "\"\<$$  \\n \\n \\\\textbf{N\[UAcute]mero de Provas \
Distintas:} $$\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"ReleaseHold", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ScientificForm", "[", 
             RowBox[{"N", "[", 
              RowBox[{"variacao3", ",", "4"}], "]"}], "]"}], "]"}], "]"}], 
          "]"}], "<>", 
         "\"\<$$ \\n \\n \\\\textbf{Probabilidade de duas Provas Iguais (1500 \
alunos):} $$\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"TeXForm", "[", 
           RowBox[{"ScientificForm", "[", 
            RowBox[{"N", "[", 
             RowBox[{"prob", ",", "4"}], "]"}], "]"}], "]"}], "]"}], "<>", 
         "\"\<$$ \\\\vspace{0.2cm}\\\\hrule\\\\end{ExerciseList} \
\\\\end{multicols}\\\\end{document}\>\""}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "saidasl", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"SetDirectory", "[", 
       RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Geraq", "[", "n_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"quest", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Q\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"answer", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<Ans\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"vari", "=", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<valor\>\"", "<>", 
          RowBox[{"ToString", "[", "n", "]"}]}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"DeleteDuplicates", "[", "answer", "]"}], "]"}], "<", 
           RowBox[{"Length", "[", "answer", "]"}]}], ",", 
          RowBox[{
           RowBox[{"Print", "[", "n", "]"}], ";", 
           RowBox[{"Print", "[", 
            RowBox[{"{", 
             RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}], 
            "]"}]}]}], "]"}], ",", 
        RowBox[{"Evaluate", "[", " ", 
         RowBox[{"vari", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
        RowBox[{"Evaluate", "[", " ", 
         RowBox[{"vari", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
        RowBox[{"Evaluate", "[", " ", 
         RowBox[{"vari", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "]"}], "]"}]}], 
    "]"}]}], "\[IndentingNewLine]", "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Testar", "[", "lista_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"nb", "=", 
      RowBox[{"NotebookOpen", "[", 
       RowBox[{"docpath", "<>", "lista", "<>", "\"\<.nb\>\""}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "a", ",", "b", ",", "x", ",", "y", ",", "Quest", ",", "quest", ",", 
       "answer", ",", "vari", ",", "valor", ",", "resp", ",", "n", ",", 
       "substituicoes", ",", "\[Alpha]", ",", " ", "\[Beta]", ",", "\[Gamma]",
        ",", "questao1", ",", "questao2", ",", "questao3", ",", "questao4", 
       ",", "questao5", ",", "questao6", ",", "questao7", ",", "questao8", 
       ",", "questao9", ",", "questao10", ",", "questao11", ",", "questao12", 
       ",", "questao13", ",", "titulo", ",", "assuntos"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Clear", "[", 
      RowBox[{
      "\"\<exp*\>\"", ",", "\"\<Q1*\>\"", ",", "\"\<Q2*\>\"", ",", 
       "\"\<Q3*\>\"", ",", "\"\<Q4*\>\"", ",", "\"\<Q5*\>\"", ",", 
       "\"\<valor*\>\"", ",", "\"\<Ans*\>\""}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"NotebookEvaluate", "[", "nb", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"DeleteDuplicates", "[", 
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Geraq", "[", "i", "]"}], ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"Sort", "[", 
            RowBox[{"Flatten", "[", "Quest", "]"}], "]"}]}], "}"}]}], "]"}], 
       "]"}], "]"}]}]}], "]"}]}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.610883451058154*^9, 3.610883515309449*^9}, {
   3.612117207633317*^9, 3.6121172168564157`*^9}, 3.620568973816977*^9, {
   3.620569438898876*^9, 3.620569445398933*^9}, {3.6205694819328947`*^9, 
   3.620569482481943*^9}, {3.6205695132811737`*^9, 3.6205695138546963`*^9}, {
   3.620570275156146*^9, 3.620570275758284*^9}, {3.620591022970688*^9, 
   3.6205910512008057`*^9}, {3.620660782645073*^9, 3.620660891826578*^9}, {
   3.620660945058743*^9, 3.62066103406485*^9}, {3.620661367456171*^9, 
   3.620661372865801*^9}, 3.620661714856061*^9, {3.620661785337056*^9, 
   3.6206617860649843`*^9}, {3.620661840408977*^9, 3.620661842655702*^9}, {
   3.6206884238666363`*^9, 3.6206884796620207`*^9}, {3.620688564627327*^9, 
   3.620688591684573*^9}, {3.6206886507065077`*^9, 3.620688692654564*^9}, {
   3.620688729708282*^9, 3.6206887775265512`*^9}, 3.620688810963434*^9, {
   3.6206888450917673`*^9, 3.620688846549694*^9}, {3.620689143628695*^9, 
   3.620689173091115*^9}, {3.6206892231101217`*^9, 3.620689259922909*^9}, {
   3.6206892911136017`*^9, 3.620689292851791*^9}, 3.620689495759767*^9, 
   3.620689536324601*^9, {3.620689670552837*^9, 3.620689687302895*^9}, 
   3.620689811500877*^9, {3.620689899144586*^9, 3.620689902279904*^9}, {
   3.621086957479136*^9, 3.621086958084428*^9}, {3.6215308578172398`*^9, 
   3.621530859241005*^9}, 3.621531179709065*^9, {3.6518476988693438`*^9, 
   3.651847699315489*^9}, {3.6836271315734262`*^9, 3.68362713687853*^9}, {
   3.683648847267846*^9, 3.683648847938738*^9}, {3.7295284276446457`*^9, 
   3.7295284342895803`*^9}, {3.729528644942075*^9, 3.729528672751955*^9}, 
   3.729528759272966*^9, {3.729528811481402*^9, 3.7295288190885963`*^9}, {
   3.729528855141169*^9, 3.729529027767275*^9}, {3.729529062507071*^9, 
   3.72952907021278*^9}, 3.729531176212031*^9, {3.7295348884619827`*^9, 
   3.729534916864839*^9}, {3.7295356400952063`*^9, 3.729535649169774*^9}, 
   3.729535759584413*^9, {3.7295358146616364`*^9, 3.729535817998258*^9}, {
   3.729535854389546*^9, 3.7295358546483297`*^9}, 3.729535916933988*^9, {
   3.72953630045126*^9, 3.729536328772504*^9}, {3.729541971537199*^9, 
   3.729541980794376*^9}, {3.729542059380825*^9, 3.729542059983255*^9}, {
   3.729542143244582*^9, 3.729542406005423*^9}, {3.729542479637154*^9, 
   3.7295424905497713`*^9}, {3.729542559341501*^9, 3.729542562642708*^9}, {
   3.72954261797668*^9, 3.729542629250979*^9}, {3.729542810093523*^9, 
   3.729542815914263*^9}, {3.729543386625787*^9, 3.729543410479096*^9}, {
   3.729543488524714*^9, 3.729543520693553*^9}, {3.738590527009143*^9, 
   3.7385905348284903`*^9}, {3.738590608940982*^9, 3.7385906231857367`*^9}, {
   3.738590663408967*^9, 3.738590665895898*^9}, {3.738590791330617*^9, 
   3.738590812360011*^9}, {3.7385911098984003`*^9, 3.738591110805841*^9}, {
   3.7385911894691133`*^9, 3.7385912323536*^9}, 3.7385924714045467`*^9, 
   3.7385925926826143`*^9, {3.800793115190736*^9, 3.800793147378572*^9}, {
   3.800793177511114*^9, 3.800793242511806*^9}, {3.800793294616762*^9, 
   3.800793325865151*^9}, {3.80079336101158*^9, 3.800793361845748*^9}, {
   3.80079341443862*^9, 3.800793419317172*^9}, {3.8007934734378357`*^9, 
   3.800793474530099*^9}, {3.8007936490934057`*^9, 3.800793650434586*^9}, {
   3.800793787606092*^9, 3.800793813646152*^9}, 3.800793847956122*^9, 
   3.8007939974175873`*^9, {3.8031157138148203`*^9, 3.803115721924848*^9}, {
   3.803163563407642*^9, 3.803163565618228*^9}, {3.803163663008978*^9, 
   3.8031636701067533`*^9}, {3.803163745085348*^9, 3.8031637517689943`*^9}, {
   3.8031639851903467`*^9, 3.803163992229065*^9}, {3.803164087639773*^9, 
   3.803164088238653*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"ad751863-6487-4d15-b3bc-8327a4ee9dd7"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.73859108423422*^9, 3.738591104434843*^9}, {
  3.8007930504295063`*^9, 3.800793055130507*^9}, {3.800793154590094*^9, 
  3.800793166284823*^9}},ExpressionUUID->"baff8bbd-f208-4208-8629-\
8b7083a401dc"],

Cell[CellGroupData[{

Cell["Exportar Moodle", "Section",
 CellChangeTimes->{{3.6104046435952806`*^9, 3.610404658976598*^9}, {
  3.6134198237034197`*^9, 3.6134198267485037`*^9}, {3.738590456702098*^9, 
  3.7385904585076*^9}, {3.800793225033572*^9, 
  3.80079322602518*^9}},ExpressionUUID->"1ed2ee8e-082a-4d3d-9b63-\
70bdd99d711f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ExportarMoodle", "[", "\"\<Lista0\>\"", "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.61040393031284*^9, 3.61040427904611*^9}, {
   3.610404315843944*^9, 3.610404370627762*^9}, {3.6104044453787317`*^9, 
   3.6104045144176807`*^9}, {3.610404566515251*^9, 3.6104045805922194`*^9}, {
   3.610404638696878*^9, 3.610404841156437*^9}, {3.61040498334123*^9, 
   3.6104049891207657`*^9}, {3.610405059727089*^9, 3.610405061577692*^9}, 
   3.6104051422739477`*^9, {3.610405178338828*^9, 3.6104052222289658`*^9}, {
   3.61040525833309*^9, 3.610405473792368*^9}, {3.610405649668404*^9, 
   3.610405721936831*^9}, {3.610405788635785*^9, 3.610405823078347*^9}, {
   3.61040587067948*^9, 3.6104059001646*^9}, {3.610807878099922*^9, 
   3.610807878754608*^9}, {3.610808947785499*^9, 3.6108089483864803`*^9}, {
   3.610820849339266*^9, 3.6108208504276953`*^9}, {3.610820894864444*^9, 
   3.610820900203629*^9}, {3.610820934072443*^9, 3.6108209364987497`*^9}, {
   3.610837582641984*^9, 3.610837608468857*^9}, {3.610837666033841*^9, 
   3.6108376774565496`*^9}, {3.610837824882174*^9, 3.6108378544874153`*^9}, {
   3.610838001014221*^9, 3.610838029679242*^9}, {3.61083823299778*^9, 
   3.61083823424669*^9}, 3.6108382760439053`*^9, {3.610838364435761*^9, 
   3.610838383928031*^9}, {3.610838532604064*^9, 3.610838552801955*^9}, {
   3.610838606446745*^9, 3.6108387312197027`*^9}, 3.610838803692625*^9, {
   3.610838855956544*^9, 3.610838858270533*^9}, {3.61083894020823*^9, 
   3.610838955948*^9}, {3.610839341456211*^9, 3.6108393429771214`*^9}, {
   3.6108394216799583`*^9, 3.6108394223834763`*^9}, {3.6108791362087593`*^9, 
   3.610879136505887*^9}, {3.6108835647715054`*^9, 3.610883567567973*^9}, {
   3.610889443348164*^9, 3.610889444394491*^9}, 3.610889476610413*^9, {
   3.610890473961156*^9, 3.610890488349057*^9}, 3.610890550047555*^9, {
   3.6108906468622437`*^9, 3.6108906479701643`*^9}, {3.6108906828014507`*^9, 
   3.6108907207584476`*^9}, {3.610890793589838*^9, 3.6108908411974773`*^9}, {
   3.6109008177036037`*^9, 3.610900818122251*^9}, {3.610900868184383*^9, 
   3.6109008687260323`*^9}, {3.612117071311076*^9, 3.6121170771759977`*^9}, {
   3.612117254046661*^9, 3.6121172544585123`*^9}, {3.612354981858371*^9, 
   3.6123549913413353`*^9}, {3.613408709880595*^9, 3.6134087103107567`*^9}, {
   3.6134087689679937`*^9, 3.613408771693349*^9}, 3.613408822941621*^9, {
   3.613408854176394*^9, 3.6134088719278193`*^9}, {3.613408921810358*^9, 
   3.613409007847816*^9}, {3.613409050898571*^9, 3.613409073171233*^9}, 
   3.613409207274653*^9, {3.61340950427682*^9, 3.613409505573559*^9}, 
   3.613409556190762*^9, {3.613410080086904*^9, 3.613410080491315*^9}, 
   3.613410505917233*^9, {3.613410909553421*^9, 3.613410912547285*^9}, {
   3.613416651401112*^9, 3.613416673183702*^9}, {3.6134167539021273`*^9, 
   3.613416762515691*^9}, 3.613416818317833*^9, {3.613416895968573*^9, 
   3.613416902837722*^9}, {3.613418130669793*^9, 3.613418169519411*^9}, {
   3.613418467242094*^9, 3.613418516312193*^9}, {3.61341982899811*^9, 
   3.613419853814494*^9}, {3.613419889784305*^9, 3.6134198906706038`*^9}, {
   3.613426498929738*^9, 3.613426505718327*^9}, {3.613426603024189*^9, 
   3.613426634792178*^9}, {3.6134286203175087`*^9, 3.613428697870976*^9}, {
   3.6134288470758753`*^9, 3.613428854853833*^9}, {3.6134296443112297`*^9, 
   3.6134296509070253`*^9}, 3.613430205547956*^9, {3.613430768318202*^9, 
   3.61343081724727*^9}, {3.6134310688985767`*^9, 3.613431131879857*^9}, {
   3.6134325646940947`*^9, 3.61343258929502*^9}, {3.613433072608427*^9, 
   3.613433121432588*^9}, {3.613433265220338*^9, 3.613433286733073*^9}, {
   3.613435673514361*^9, 3.613435675268812*^9}, {3.614169413883717*^9, 
   3.614169419159709*^9}, {3.614733857664171*^9, 3.614733881156838*^9}, {
   3.614733924039021*^9, 3.614733924919289*^9}, {3.615288971906492*^9, 
   3.6152889846684227`*^9}, {3.61583700448945*^9, 3.615837005002267*^9}, {
   3.6158384183441973`*^9, 3.615838421715209*^9}, {3.615844320317564*^9, 
   3.615844385822382*^9}, {3.6158444199617167`*^9, 3.6158444541381397`*^9}, {
   3.615845015559119*^9, 3.615845030567354*^9}, {3.6206893108014107`*^9, 
   3.620689314301*^9}, {3.6206898675145187`*^9, 3.62068988964028*^9}, {
   3.621086700449594*^9, 3.621086701295321*^9}, {3.621175366570375*^9, 
   3.6211753833938837`*^9}, 3.621175796715328*^9, 3.621257538587098*^9, {
   3.621257639047965*^9, 3.6212576664093437`*^9}, {3.621257756342945*^9, 
   3.6212577945201674`*^9}, 3.62125798463017*^9, {3.6212593181825314`*^9, 
   3.621259322005373*^9}, {3.6212617276394167`*^9, 3.621261800637436*^9}, {
   3.621262686393427*^9, 3.621262717376226*^9}, 3.621262841982966*^9, {
   3.6212631120098352`*^9, 3.6212631329498587`*^9}, {3.62126321137037*^9, 
   3.621263224979013*^9}, {3.6212633087807837`*^9, 3.6212633131645317`*^9}, 
   3.62126354214047*^9, 3.621263622418696*^9, 3.6212637134124517`*^9, {
   3.6212638787742434`*^9, 3.621263879069067*^9}, {3.621263973397276*^9, 
   3.621264026971467*^9}, {3.621264105259342*^9, 3.621264141254579*^9}, 
   3.6212647121862698`*^9, {3.621266171400504*^9, 3.621266171964465*^9}, {
   3.62185704476375*^9, 3.621857060715392*^9}, {3.6229107503132067`*^9, 
   3.622910805201022*^9}, {3.623065323221661*^9, 3.623065328540759*^9}, {
   3.623065372413884*^9, 3.623065380716072*^9}, {3.623065996148923*^9, 
   3.623066000739451*^9}, {3.623066059851811*^9, 3.623066061291313*^9}, {
   3.623592303213808*^9, 3.623592373496125*^9}, {3.623593853290106*^9, 
   3.623593853729719*^9}, {3.623593954961389*^9, 3.623593996081503*^9}, {
   3.623632347550877*^9, 3.62363239479379*^9}, {3.623632434184105*^9, 
   3.623632435228232*^9}, 3.623632571650358*^9, {3.625322739546362*^9, 
   3.625322782689663*^9}, {3.6267064962239857`*^9, 3.626706520794075*^9}, 
   3.6520273813677397`*^9, {3.653255686194005*^9, 3.653255690838707*^9}, {
   3.653822802543342*^9, 3.653822803190037*^9}, {3.654536199659565*^9, 
   3.654536200030443*^9}, {3.655145547210826*^9, 3.655145548958744*^9}, {
   3.656524200989694*^9, 3.656524224156412*^9}, {3.656524257231553*^9, 
   3.6565242734927597`*^9}, {3.65694958079405*^9, 3.6569495811829853`*^9}, {
   3.656950370320579*^9, 3.656950408947525*^9}, {3.656952900277218*^9, 
   3.656952907825757*^9}, {3.6836240044172697`*^9, 3.683624006187429*^9}, 
   3.683629489276154*^9, {3.6837145457397623`*^9, 3.683714600189458*^9}, {
   3.683714672532484*^9, 3.6837147268176622`*^9}, {3.683714830520309*^9, 
   3.683714843947536*^9}, 3.6837148966633673`*^9, {3.684233963166691*^9, 
   3.6842340155109386`*^9}, {3.684236293537641*^9, 3.684236327595945*^9}, {
   3.684250353823215*^9, 3.684250354062739*^9}, {3.684250510216234*^9, 
   3.6842505291598787`*^9}, {3.685442827543043*^9, 3.685442828468316*^9}, 
   3.685443841736437*^9, {3.686684076073649*^9, 3.6866840764011087`*^9}, {
   3.728344463343679*^9, 3.7283444659975452`*^9}, {3.729529098115087*^9, 
   3.729529099801394*^9}, 3.729531196131261*^9, {3.729534515883868*^9, 
   3.729534517090904*^9}, {3.729534757429017*^9, 3.729534757641028*^9}, {
   3.729541604388538*^9, 3.729541612920932*^9}, {3.729541922690608*^9, 
   3.729541934403384*^9}, {3.729542429015724*^9, 3.729542431897458*^9}, {
   3.729542760413591*^9, 3.729542771633209*^9}, {3.729544780347782*^9, 
   3.729544843079706*^9}, {3.729544909546071*^9, 3.729544945409728*^9}, 
   3.7295923263294067`*^9, {3.729593496638359*^9, 3.729593496807947*^9}, {
   3.729595114029189*^9, 3.729595157050725*^9}, {3.729595909250245*^9, 
   3.729595915622264*^9}, {3.729595946014632*^9, 3.729595967282214*^9}, {
   3.729596041705942*^9, 3.7295961633815527`*^9}, {3.738591353266716*^9, 
   3.738591417269911*^9}, {3.738591458930675*^9, 3.738591460090671*^9}, {
   3.738625687668929*^9, 3.7386257074463*^9}, {3.738625750928845*^9, 
   3.73862575123075*^9}, {3.738625805664074*^9, 3.73862580740556*^9}, {
   3.740408826540954*^9, 3.740408827555674*^9}, {3.742406668272835*^9, 
   3.742406677931827*^9}, {3.7424084883558683`*^9, 3.742408492881816*^9}, {
   3.742408606192086*^9, 3.742408614456499*^9}, {3.7424118579135723`*^9, 
   3.742411859062845*^9}, {3.74241248706065*^9, 3.7424124951235237`*^9}, {
   3.742414487242351*^9, 3.742414491132373*^9}, {3.742414880897806*^9, 
   3.74241491787993*^9}, {3.742414957900558*^9, 3.742414960813204*^9}, 
   3.742415038943426*^9, {3.7424837607682667`*^9, 3.742483760938402*^9}, {
   3.7440428073882093`*^9, 3.744042808326377*^9}, {3.745167464753623*^9, 
   3.745167466850135*^9}, {3.745766511646638*^9, 3.745766512349852*^9}, {
   3.745767665497945*^9, 3.74576768972176*^9}, {3.745767743658442*^9, 
   3.745767882506783*^9}, {3.7457679126533012`*^9, 3.7457679381488543`*^9}, 
   3.74577822393613*^9, {3.7457792727949057`*^9, 3.745779276686475*^9}, 
   3.7474218379728937`*^9, {3.74810563076993*^9, 3.7481056315380487`*^9}, {
   3.749068234258665*^9, 3.749068234789382*^9}, {3.7492189059752073`*^9, 
   3.74921894048851*^9}, {3.7492198040487947`*^9, 3.749219804387581*^9}, {
   3.749731994580429*^9, 3.749732031061489*^9}, 3.7497483633986807`*^9, 
   3.749927775041019*^9, {3.750601508256661*^9, 3.7506015085036507`*^9}, {
   3.751560651921852*^9, 3.7515606525780687`*^9}, {3.7519985314486237`*^9, 
   3.75199853202642*^9}, {3.7621651424739437`*^9, 3.762165144290197*^9}, {
   3.7625334851851883`*^9, 3.762533491600478*^9}, 3.763391430694846*^9, {
   3.763895587855035*^9, 3.76389558997504*^9}, {3.765215022604265*^9, 
   3.765215023106605*^9}, {3.7657322632111692`*^9, 3.765732263971117*^9}, {
   3.766424627577495*^9, 3.7664246279625463`*^9}, {3.766856126672824*^9, 
   3.766856126902689*^9}, {3.766857180119553*^9, 3.766857180486019*^9}, {
   3.767607864755707*^9, 3.767607865090469*^9}, {3.768218198068782*^9, 
   3.768218201315174*^9}, {3.768843748719521*^9, 3.76884374887537*^9}, {
   3.769454933299568*^9, 3.7694549339932613`*^9}, {3.77669856747698*^9, 
   3.7766985706306963`*^9}, {3.777287590520218*^9, 3.777287590865858*^9}, {
   3.777319626980661*^9, 3.777319629214058*^9}, {3.781290164429451*^9, 
   3.781290165197398*^9}, {3.782693120502439*^9, 3.782693122945045*^9}, {
   3.782693155904622*^9, 3.782693156471924*^9}, {3.783364621654294*^9, 
   3.78336463292173*^9}, 3.8007930480407476`*^9, 3.8007931123242607`*^9, {
   3.800793227892282*^9, 3.800793250166119*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"b7846c49-82f9-4fe7-9c5e-f5ec0394780d"],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{
  3.803115741839015*^9, 3.803163494910446*^9, {3.803163575892454*^9, 
   3.803163590006398*^9}, 3.803163685033057*^9, {3.80316384493259*^9, 
   3.803163898460269*^9}, 3.803164020298552*^9, 3.803164105444635*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"7b109075-2b74-4f6a-8347-33fb80a10055"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{
  3.803115741839015*^9, 3.803163494910446*^9, {3.803163575892454*^9, 
   3.803163590006398*^9}, 3.803163685033057*^9, {3.80316384493259*^9, 
   3.803163898460269*^9}, 3.803164020298552*^9, 3.803164105562606*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"eec5ae15-98de-44c8-b402-c9c86e9af684"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exportar Latex ", "Section",
 CellChangeTimes->{{3.6104046435952806`*^9, 3.610404658976598*^9}, {
   3.6109010635139503`*^9, 3.610901065530192*^9}, {3.610901836781728*^9, 
   3.6109018385616093`*^9}, {3.612132534446508*^9, 3.612132538216548*^9}, 
   3.612358916859396*^9, {3.6218521140380583`*^9, 3.6218521169106007`*^9}, {
   3.6518477132535467`*^9, 3.6518477141013927`*^9}, 
   3.800793371730753*^9},ExpressionUUID->"745f3e89-8551-4c2a-8b7d-\
c34c2bcdad65"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ExportarLaTeX", "[", "\"\<Lista0\>\"", "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.61040393031284*^9, 3.61040427904611*^9}, {
   3.610404315843944*^9, 3.610404370627762*^9}, {3.6104044453787317`*^9, 
   3.6104045144176807`*^9}, {3.610404566515251*^9, 3.6104045805922194`*^9}, {
   3.610404638696878*^9, 3.610404841156437*^9}, {3.61040498334123*^9, 
   3.6104049891207657`*^9}, {3.610405059727089*^9, 3.610405061577692*^9}, 
   3.6104051422739477`*^9, {3.610405178338828*^9, 3.6104052222289658`*^9}, {
   3.61040525833309*^9, 3.610405473792368*^9}, {3.610405649668404*^9, 
   3.610405721936831*^9}, {3.610405788635785*^9, 3.610405823078347*^9}, {
   3.61040587067948*^9, 3.6104059001646*^9}, {3.610807878099922*^9, 
   3.610807878754608*^9}, {3.610808947785499*^9, 3.6108089483864803`*^9}, {
   3.610820849339266*^9, 3.6108208504276953`*^9}, {3.610820894864444*^9, 
   3.610820900203629*^9}, {3.610820934072443*^9, 3.6108209364987497`*^9}, {
   3.610837582641984*^9, 3.610837608468857*^9}, {3.610837666033841*^9, 
   3.6108376774565496`*^9}, {3.610837824882174*^9, 3.6108378544874153`*^9}, {
   3.610838001014221*^9, 3.610838029679242*^9}, {3.61083823299778*^9, 
   3.61083823424669*^9}, 3.6108382760439053`*^9, {3.610838364435761*^9, 
   3.610838383928031*^9}, {3.610838532604064*^9, 3.610838552801955*^9}, {
   3.610838606446745*^9, 3.6108387312197027`*^9}, 3.610838803692625*^9, {
   3.610838855956544*^9, 3.610838858270533*^9}, {3.61083894020823*^9, 
   3.610838955948*^9}, {3.610839341456211*^9, 3.6108393429771214`*^9}, {
   3.6108394216799583`*^9, 3.6108394223834763`*^9}, {3.6108791362087593`*^9, 
   3.610879136505887*^9}, {3.6108835647715054`*^9, 3.610883567567973*^9}, {
   3.610889443348164*^9, 3.610889444394491*^9}, 3.610889476610413*^9, {
   3.610890473961156*^9, 3.610890488349057*^9}, 3.610890550047555*^9, {
   3.6108906468622437`*^9, 3.6108906479701643`*^9}, {3.6108906828014507`*^9, 
   3.6108907207584476`*^9}, {3.610890793589838*^9, 3.6108908411974773`*^9}, {
   3.6109008177036037`*^9, 3.610900818122251*^9}, {3.610900868184383*^9, 
   3.6109008687260323`*^9}, {3.610901085668612*^9, 3.610901120944536*^9}, {
   3.610901151680031*^9, 3.610901157690543*^9}, 3.610901263364259*^9, 
   3.610901305077421*^9, {3.610901378598036*^9, 3.610901431884865*^9}, {
   3.6109014670232983`*^9, 3.610901478484868*^9}, {3.610901579852367*^9, 
   3.610901589251712*^9}, {3.610901806663438*^9, 3.6109018413752813`*^9}, {
   3.610903044863649*^9, 3.610903060402341*^9}, {3.61090457531185*^9, 
   3.610904600282473*^9}, 3.610904638118393*^9, {3.610904697751294*^9, 
   3.610904710037862*^9}, {3.610905240613872*^9, 3.61090524204935*^9}, {
   3.6109056701903152`*^9, 3.6109056719856873`*^9}, {3.610905909139244*^9, 
   3.610905912503661*^9}, 3.6109061085344477`*^9, {3.610982347158904*^9, 
   3.6109824377590017`*^9}, {3.610982592974917*^9, 3.610982638007168*^9}, 
   3.610982718566325*^9, {3.6109827605949383`*^9, 3.610982770916793*^9}, {
   3.610982835767982*^9, 3.610982839641822*^9}, 3.611489393447363*^9, 
   3.612117324599761*^9, {3.6121244966271563`*^9, 3.612124502260605*^9}, {
   3.612132552290122*^9, 3.612132618314851*^9}, {3.612132659433248*^9, 
   3.6121326639322042`*^9}, {3.612132701615468*^9, 3.612133016913699*^9}, {
   3.612133071087562*^9, 3.612133073087143*^9}, {3.6121331913575583`*^9, 
   3.612133218199154*^9}, {3.612133277755321*^9, 3.612133285314888*^9}, 
   3.6121333825151243`*^9, {3.612133523697966*^9, 3.612133542415803*^9}, {
   3.612133635271545*^9, 3.612133644548473*^9}, {3.6121338134071627`*^9, 
   3.612133813928088*^9}, {3.6121339921658497`*^9, 3.612134022857265*^9}, 
   3.6121340959935923`*^9, {3.612134479696004*^9, 3.612134544161828*^9}, {
   3.6121346043022127`*^9, 3.6121347133307467`*^9}, {3.612134753178173*^9, 
   3.612134779030958*^9}, 3.612134813302647*^9, {3.612135292390973*^9, 
   3.6121353146359253`*^9}, {3.612135428628826*^9, 3.6121354608374023`*^9}, 
   3.612135493775907*^9, {3.612136228862088*^9, 3.612136246425014*^9}, {
   3.6121368257466917`*^9, 3.6121369152573853`*^9}, {3.612136960509028*^9, 
   3.612136962083765*^9}, {3.612137860065589*^9, 3.6121378635618668`*^9}, {
   3.612137898746746*^9, 3.612137929093357*^9}, {3.612138207050579*^9, 
   3.612138212925336*^9}, {3.6121389631769876`*^9, 3.612139069131146*^9}, {
   3.6121392393288107`*^9, 3.6121392474846163`*^9}, 3.612139618320697*^9, {
   3.612139828900518*^9, 3.6121398326479607`*^9}, {3.612139893534892*^9, 
   3.6121398940545397`*^9}, 3.612140419727129*^9, {3.61214247338732*^9, 
   3.6121424794456863`*^9}, 3.6121474610024014`*^9, 3.612148126289729*^9, {
   3.612148609516081*^9, 3.612148612134802*^9}, {3.612150555337873*^9, 
   3.612150574886861*^9}, {3.612153121900406*^9, 3.612153207640132*^9}, {
   3.6121867604566927`*^9, 3.612186777961047*^9}, {3.612187093048188*^9, 
   3.6121871226983232`*^9}, {3.61219103774736*^9, 3.612191143701229*^9}, {
   3.61219117914318*^9, 3.612191189239362*^9}, {3.612191274411181*^9, 
   3.612191283933383*^9}, {3.612191318678884*^9, 3.612191323697095*^9}, {
   3.612191409038522*^9, 3.612191471406578*^9}, {3.612191533672823*^9, 
   3.61219154028755*^9}, {3.612191665229958*^9, 3.6121916690102577`*^9}, {
   3.612191700463766*^9, 3.6121917013951607`*^9}, {3.612191766618436*^9, 
   3.612191781801446*^9}, {3.612195921151116*^9, 3.612195983730529*^9}, {
   3.6121962996014023`*^9, 3.612196309308585*^9}, {3.612196385487145*^9, 
   3.6121963878884087`*^9}, {3.612196467538136*^9, 3.612196482921446*^9}, {
   3.61219667969906*^9, 3.612196686022893*^9}, {3.612196729679098*^9, 
   3.612196777320465*^9}, {3.612199956577673*^9, 3.612200000497313*^9}, {
   3.6122086747868557`*^9, 3.612208696478938*^9}, {3.612209033481987*^9, 
   3.6122090706899*^9}, {3.612209130945059*^9, 3.6122091597386217`*^9}, {
   3.61220942493272*^9, 3.6122094364619083`*^9}, 3.61220946871402*^9, {
   3.6122095042894707`*^9, 3.612209507851223*^9}, {3.6122238990418673`*^9, 
   3.612223907594981*^9}, 3.612224370174828*^9, {3.612224636002233*^9, 
   3.612224640696517*^9}, {3.612309352431889*^9, 3.612309529494788*^9}, {
   3.6123095719799547`*^9, 3.612309602912635*^9}, 3.612309639108469*^9, {
   3.612309744423901*^9, 3.612309956349902*^9}, {3.612310004955711*^9, 
   3.612310041724163*^9}, {3.61231009172288*^9, 3.612310105497376*^9}, {
   3.612310282024334*^9, 3.612310297634782*^9}, {3.612310380545772*^9, 
   3.612310402050541*^9}, {3.6123104829761477`*^9, 3.6123105203183804`*^9}, {
   3.6123109807147017`*^9, 3.6123110290487843`*^9}, 3.612311076122395*^9, {
   3.612311258272912*^9, 3.612311261077038*^9}, {3.6123112939090023`*^9, 
   3.6123113071464787`*^9}, {3.612311353013213*^9, 3.612311373476663*^9}, {
   3.612311414680766*^9, 3.6123114168372803`*^9}, {3.612311582058507*^9, 
   3.612311603927648*^9}, 3.612311637476242*^9, 3.612311682552444*^9, {
   3.612311732816723*^9, 3.612311752227045*^9}, {3.612311851307083*^9, 
   3.61231187402594*^9}, 3.612312022040797*^9, {3.612312053946303*^9, 
   3.6123120551672688`*^9}, {3.6123120960273657`*^9, 3.61231213663021*^9}, 
   3.612312206368682*^9, {3.612312250935195*^9, 3.612312267686692*^9}, {
   3.6123123015281887`*^9, 3.6123123100667963`*^9}, 3.612312383930788*^9, {
   3.612312416955331*^9, 3.612312428168983*^9}, {3.612312578009777*^9, 
   3.612312585608816*^9}, {3.612312642090641*^9, 3.612312653166174*^9}, {
   3.612312694587462*^9, 3.6123126981749773`*^9}, {3.612312792005701*^9, 
   3.6123129090671167`*^9}, {3.612312952058963*^9, 3.6123129589970427`*^9}, {
   3.6123130363357286`*^9, 3.612313070711072*^9}, {3.612313134478304*^9, 
   3.61231316087364*^9}, {3.612313246934559*^9, 3.6123132956792507`*^9}, 
   3.6123133521860523`*^9, {3.6123133854414663`*^9, 3.612313385939887*^9}, {
   3.6123138815237207`*^9, 3.6123138825732117`*^9}, {3.612313914218959*^9, 
   3.612313935665511*^9}, {3.612313985208301*^9, 3.612314000929579*^9}, {
   3.612314038234235*^9, 3.612314075426499*^9}, {3.612314262050662*^9, 
   3.612314291694665*^9}, 3.6123547533648148`*^9, {3.6123548158149652`*^9, 
   3.612354816156369*^9}, {3.612355840005837*^9, 3.612355885331118*^9}, {
   3.612355924058361*^9, 3.6123559245893307`*^9}, {3.6123560493613*^9, 
   3.61235619404364*^9}, {3.612356245732053*^9, 3.612356273502489*^9}, {
   3.612356428574298*^9, 3.612356458330989*^9}, {3.612356612528193*^9, 
   3.6123566128576508`*^9}, {3.6123568107238398`*^9, 3.612356814667239*^9}, {
   3.6123568773952007`*^9, 3.612356887712818*^9}, {3.6123569864647913`*^9, 
   3.612356993420089*^9}, {3.6123570631968*^9, 3.612357126365987*^9}, {
   3.612357158876491*^9, 3.612357204576144*^9}, {3.612357252750523*^9, 
   3.6123573719998426`*^9}, {3.6123574292058887`*^9, 3.61235743857594*^9}, {
   3.612357563933485*^9, 3.6123576469211693`*^9}, {3.6123577384598093`*^9, 
   3.612357764782613*^9}, {3.612358058946046*^9, 3.612358061270177*^9}, 
   3.612358916859644*^9, {3.612392838179472*^9, 3.612392948910697*^9}, {
   3.612393215839902*^9, 3.6123932239599743`*^9}, 3.6123932572704973`*^9, {
   3.612393409950881*^9, 3.612393425733245*^9}, {3.612393505236205*^9, 
   3.612393522404132*^9}, {3.6123935643256893`*^9, 3.6123935806231813`*^9}, {
   3.612393619299914*^9, 3.612393620705277*^9}, {3.612393719960956*^9, 
   3.6123937433301477`*^9}, {3.612393828909211*^9, 3.612393893514289*^9}, {
   3.6123941751456203`*^9, 3.612394175731824*^9}, {3.61239430249559*^9, 
   3.612394328557548*^9}, {3.612394405742367*^9, 3.6123944842892942`*^9}, {
   3.612394602486434*^9, 3.612394604680079*^9}, {3.612394723027266*^9, 
   3.61239475211371*^9}, {3.612394846092388*^9, 3.612394902601666*^9}, {
   3.612394943378978*^9, 3.612394943818931*^9}, {3.612394993606345*^9, 
   3.612395032581257*^9}, {3.612395071896225*^9, 3.612395092871356*^9}, {
   3.612396785520466*^9, 3.612396788243944*^9}, 3.614376280128408*^9, {
   3.6152889515720673`*^9, 3.615288958901613*^9}, 3.615293320585533*^9, {
   3.62056892841343*^9, 3.6205689287586613`*^9}, {3.620569133239995*^9, 
   3.620569160797967*^9}, {3.6205692091961527`*^9, 3.6205692105938396`*^9}, {
   3.620569259629142*^9, 3.620569261470912*^9}, {3.6205696254367437`*^9, 
   3.620569669028823*^9}, {3.620569951273419*^9, 3.620569956292468*^9}, {
   3.620570159870721*^9, 3.620570168509006*^9}, {3.6205704010419292`*^9, 
   3.6205704539404297`*^9}, {3.6205706125407143`*^9, 
   3.6205706496492453`*^9}, {3.620571151190014*^9, 3.620571152920662*^9}, 
   3.6205714226711893`*^9, {3.620571549833353*^9, 3.620571550306131*^9}, {
   3.620571744625606*^9, 3.6205717711341887`*^9}, {3.62057180992161*^9, 
   3.62057181313097*^9}, {3.6205718492434673`*^9, 3.620571867040687*^9}, {
   3.620572026193475*^9, 3.620572030427038*^9}, {3.62059910284367*^9, 
   3.620599113813983*^9}, {3.620599144933305*^9, 3.620599145908861*^9}, {
   3.62060031794*^9, 3.620600327679821*^9}, {3.6206451340691442`*^9, 
   3.620645135585416*^9}, {3.620661131359219*^9, 3.620661207308803*^9}, {
   3.620661256439889*^9, 3.620661256727119*^9}, {3.620675806651519*^9, 
   3.620675809615787*^9}, {3.6206760754171467`*^9, 3.6206760772021713`*^9}, {
   3.6206762226189337`*^9, 3.620676230638135*^9}, {3.620676388819887*^9, 
   3.620676389008165*^9}, {3.620677247553018*^9, 3.62067724926639*^9}, {
   3.6215304338844833`*^9, 3.621530435116048*^9}, {3.62153047946284*^9, 
   3.621530482359014*^9}, {3.621530513603705*^9, 3.62153051397104*^9}, {
   3.621530838476202*^9, 3.621530840124976*^9}, {3.621531041344401*^9, 
   3.621531069734186*^9}, {3.621531278707571*^9, 3.621531290007738*^9}, {
   3.6215320843500843`*^9, 3.621532088364439*^9}, {3.6223881611689672`*^9, 
   3.6223881614278927`*^9}, {3.622885792233406*^9, 3.6228857951606503`*^9}, {
   3.622885837006707*^9, 3.6228858602982483`*^9}, {3.623066570168536*^9, 
   3.623066570416306*^9}, {3.623066649019685*^9, 3.623066649266296*^9}, {
   3.623497540495184*^9, 3.623497565598353*^9}, {3.623511255342822*^9, 
   3.623511259179093*^9}, {3.6235113382009363`*^9, 3.623511343112967*^9}, {
   3.623519327920514*^9, 3.62351933581665*^9}, 3.6235194023894167`*^9, {
   3.6235195071349697`*^9, 3.623519508915503*^9}, {3.62353077569916*^9, 
   3.623530797064616*^9}, {3.623531444970668*^9, 3.6235314561966248`*^9}, {
   3.626205032814653*^9, 3.626205033527987*^9}, {3.651847625780274*^9, 
   3.651847626269876*^9}, {3.6518477212622023`*^9, 3.651847724421626*^9}, {
   3.652449363979013*^9, 3.6524493667399397`*^9}, {3.653244593094351*^9, 
   3.653244593488381*^9}, {3.653694697579639*^9, 3.653694698129356*^9}, {
   3.654285003039227*^9, 3.654285003512398*^9}, {3.65452563601816*^9, 
   3.6545256479228*^9}, {3.655029035985148*^9, 3.6550290362088842`*^9}, {
   3.656518384678844*^9, 3.656518387742988*^9}, {3.656524125340211*^9, 
   3.656524151602059*^9}, 3.656524188631695*^9, {3.683567287161441*^9, 
   3.6835672888512278`*^9}, {3.6842339765024157`*^9, 3.68423398286766*^9}, {
   3.684234200075922*^9, 3.684234207876913*^9}, {3.684599677439372*^9, 
   3.684599681143776*^9}, {3.684927524494548*^9, 3.6849275249976873`*^9}, {
   3.728344573117343*^9, 3.728344574259359*^9}, {3.7399771098648233`*^9, 
   3.739977111357688*^9}, {3.739977487723428*^9, 3.739977516852578*^9}, {
   3.7399776020684032`*^9, 3.7399776363307056`*^9}, {3.7399780598271723`*^9, 
   3.7399780771143923`*^9}, {3.740412590257106*^9, 3.740412592813037*^9}, {
   3.74240789517246*^9, 3.742407909780941*^9}, {3.742408454907469*^9, 
   3.742408474671924*^9}, {3.7424119405201283`*^9, 3.74241195057131*^9}, {
   3.742414520758545*^9, 3.7424145238630123`*^9}, {3.742483583264255*^9, 
   3.742483583566935*^9}, {3.745501319919199*^9, 3.745501322830456*^9}, {
   3.7474240861796513`*^9, 3.7474240872629223`*^9}, 3.748106048915732*^9, {
   3.749068635736507*^9, 3.749068636295555*^9}, {3.749732095630619*^9, 
   3.749732100469819*^9}, 3.749749089111533*^9, {3.7499275429079313`*^9, 
   3.749927564271789*^9}, {3.749927693809669*^9, 3.749927720713036*^9}, 
   3.750601619067384*^9, {3.751561946489955*^9, 3.75156194706074*^9}, {
   3.751998765401342*^9, 3.7519987661991873`*^9}, 3.800793289795085*^9, {
   3.8007933772377462`*^9, 3.800793386746369*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"2e07a7f7-42f3-44d7-ac57-69f7e3d4cc8c"],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{
  3.800794004074843*^9, 3.800794052865559*^9, 3.803115800809422*^9, 
   3.803163418372384*^9, {3.803163767914565*^9, 3.803163801303258*^9}},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"816b2468-706f-411c-8580-f7f13b5d5f7b"],

Cell[BoxData["7"], "Print",
 CellChangeTimes->{
  3.800794004074843*^9, 3.800794052865559*^9, 3.803115800809422*^9, 
   3.803163418372384*^9, {3.803163767914565*^9, 3.8031638015891542`*^9}},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"0ec64000-81e4-44bb-a3db-b52cd28d431c"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{
  3.800794004074843*^9, 3.800794052865559*^9, 3.803115800809422*^9, 
   3.803163418372384*^9, {3.803163767914565*^9, 3.803163801593388*^9}},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"f786f1b3-db82-4bd3-bad2-79dd1d795cf2"],

Cell[BoxData["210"], "Print",
 CellChangeTimes->{
  3.800794004074843*^9, 3.800794052865559*^9, 3.803115800809422*^9, 
   3.803163418372384*^9, {3.803163767914565*^9, 3.803163802559032*^9}},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"331303fa-8383-4416-83ef-97a2be99804d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verificar Alternativas", "Title",
 CellChangeTimes->{{3.614375381977223*^9, 3.614375405155979*^9}, {
  3.800793685852622*^9, 
  3.8007936945365334`*^9}},ExpressionUUID->"ab1a0d28-0037-408c-8840-\
b8109e1731a2"],

Cell["\<\
Verifica se h\[AAcute] coincid\[EHat]ncias nas alternativas retorna as quest\
\[OTilde]es com coincid\[EHat]ncias ou Null se nenhuma\
\>", "Text",
 CellChangeTimes->{{3.6854424090624332`*^9, 3.685442412369062*^9}, {
  3.738596567957986*^9, 3.738596568124312*^9}, {3.800793697736244*^9, 
  3.800793741789797*^9}},ExpressionUUID->"81d381dd-23dc-49df-923d-\
0806fae5e193"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Testar", "[", "\"\<Lista0\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.800793669413402*^9, 3.800793679665618*^9}},
 CellLabel->
  "In[157]:=",ExpressionUUID->"e558a741-c4a6-4058-9c9d-d06449784eea"],

Cell[BoxData[
 RowBox[{"{", "Null", "}"}]], "Output",
 CellChangeTimes->{3.800793680345846*^9, 3.800793744041363*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"bbdfa53e-081d-45d8-9071-bbf04f2f4bfa"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ExportaLatex2", "[", "lista_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"quallista", "=", "lista"}], ";", "\[IndentingNewLine]", 
       RowBox[{"SetDirectory", "[", 
        RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"CreateDirectory", "[", "\"\<Testes-Tidia-latex\>\"", "]"}], 
         "\[IndentingNewLine]", "variacao"}], "=", "1"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"variacao2", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"variacao3", "=", "1"}], ";", "\[IndentingNewLine]", 
       RowBox[{"nb", "=", 
        RowBox[{"NotebookOpen", "[", 
         RowBox[{"docpath", "<>", "quallista", "<>", "\"\<.nb\>\""}], "]"}]}],
        ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Clear", "[", 
         RowBox[{
         "a", ",", "b", ",", "x", ",", "y", ",", "Quest", ",", "quest", ",", 
          "answer", ",", "vari", ",", "valor", ",", "resp", ",", "n", ",", 
          "substituicoes", ",", "\[Alpha]", ",", " ", "\[Beta]", ",", 
          "\[Gamma]", ",", "questao1", ",", "questao2", ",", "questao3", ",", 
          "questao4", ",", "questao5", ",", "questao6", ",", "questao7", ",", 
          "questao8", ",", "questao9", ",", "questao10", ",", "questao11", 
          ",", "questao12", ",", "questao13", ",", "titulo", ",", 
          "assuntos"}], "]"}], "\[IndentingNewLine]", 
        RowBox[{"Clear", "[", 
         RowBox[{
         "\"\<exp*\>\"", ",", "\"\<Q1*\>\"", ",", "\"\<Q2*\>\"", ",", 
          "\"\<Q3*\>\"", ",", "\"\<Q4*\>\"", ",", "\"\<Q5*\>\"", ",", 
          "\"\<valor*\>\"", ",", "\"\<Ans*\>\""}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"NotebookEvaluate", "[", "nb", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Questoes", "=", 
        RowBox[{"Length", "[", "Quest", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"saidasl", "=", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"docpath2", ",", 
           RowBox[{
           "quallista", "<>", "\"\<\>\"", "<>", "\"\<Total.tex\>\""}]}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"OpenWrite", "[", 
        RowBox[{"saidasl", ",", 
         RowBox[{"CharacterEncoding", "\[Rule]", "\"\<ISO8859-15\>\""}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"WriteString", "[", 
        RowBox[{"saidasl", ",", 
         RowBox[{
         "\"\<\\\\documentclass[a4paper,11pt]{scrartcl}\n \\n \
\\\\usepackage{multicol}\n\\\\addtolength{\\\\parindent}{-0.4cm} \\n\n\
\\\\setlength{\\\\topmargin}{-0.9cm}\\n\n\\\\setlength{\\\\headsep}{ -.1in} \
\\n\n\\\\setlength{\\\\textheight}{24.4cm}\\n\n\
\\\\setlength{\\\\textwidth}{18.7cm}\\n\n\
\\\\setlength{\\\\oddsidemargin}{-0.6in}\\n\n\
\\\\setlength{\\\\evensidemargin}{-0.6in}\\n\n\
\\\\setlength{\\\\marginparwidth}{ -40pt}\n\\\\setlength{\\\\marginparsep}{ \
-10pt}\n\\\\usepackage{beramono,euler,eulervm}\n\\\\usepackage{exercise} \\n \
\\\\usepackage[latin1]{inputenc} \\n \\\\usepackage{mathtools} \\n \
\\\\begin{document} \\n  \\\\begin{center} \\\\Huge \>\"", " ", "<>", 
          "titulo", "<>", " ", 
          "\"\<\\\\end{center}  \\\\vspace{1cm} \n\\\\textbf{Assuntos: }\>\"",
           "<>", "assuntos", "<>", 
          "\"\<\\\\vspace{0.5cm}  \\\\begin{multicols}{2} \
\\\\begin{ExerciseList}\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"o", "=", "1"}], ",", 
         RowBox[{"o", "<=", "Questoes"}], ",", 
         RowBox[{"o", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"imp", "=", 
           RowBox[{"Quest", "[", 
            RowBox[{"[", "o", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"lo", "=", 
           RowBox[{"Length", "[", "imp", "]"}]}], ";", "\[IndentingNewLine]", 
          
          RowBox[{"Print", "[", "o", "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"varquest", "=", 
           RowBox[{"varquest", "+", 
            RowBox[{"Length", "[", "imp", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"saidasl", ",", 
            RowBox[{"\"\<\\\\subsection*{Quest\[ATilde]o \>\"", "<>", 
             RowBox[{"ToString", "[", "o", "]"}], "<>", "\"\<}\>\""}]}], 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"variacao4", "=", "0"}], ";", "\[IndentingNewLine]", 
          RowBox[{"variacao", "=", 
           RowBox[{"Length", "[", 
            RowBox[{"Flatten", "[", "Quest", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"k", "=", "1"}], ",", 
            RowBox[{"k", "\[LessEqual]", "lo"}], ",", 
            RowBox[{"k", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", "al", "}"}], ",", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"print", "=", 
                 RowBox[{"Flatten", "[", 
                  RowBox[{
                   RowBox[{"Evaluate", "[", 
                    RowBox[{"GeraL", "[", 
                    RowBox[{"imp", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "]"}], "]"}], ",", "2"}], 
                  "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"comp", "=", 
                 RowBox[{"Evaluate", "[", 
                  RowBox[{"Length", "[", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"GeraL", "[", 
                    RowBox[{"imp", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "]"}], ",", "2"}], "]"}], 
                   "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"WriteString", "[", 
                    RowBox[{"saidasl", ",", 
                    RowBox[{"print", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"j", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}], 
                    "]"}], "]"}], ";"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"al", "=", 
                    RowBox[{"RandomInteger", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "print", "]"}]}], "}"}], "]"}]}], 
                   ";", 
                   RowBox[{"WriteString", "[", 
                    RowBox[{"saidasl", ",", 
                    RowBox[{"print", "[", 
                    RowBox[{"[", "al", "]"}], "]"}]}], "]"}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{"j", ",", "1", ",", "1"}], "}"}]}], 
                 "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
                RowBox[{"variacao2", "=", 
                 RowBox[{"(", 
                  RowBox[{"variacao2", "+", "comp"}], ")"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"variacao4", "=", 
                 RowBox[{"(", 
                  RowBox[{"variacao4", "+", "comp"}], ")"}]}], ";", 
                "\[IndentingNewLine]", 
                RowBox[{"varia", "=", "False"}], ";", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"varia", "\[Equal]", "True"}], ",", 
                  RowBox[{"WriteString", "[", 
                   RowBox[{"saidasl", ",", 
                    RowBox[{
                    "\"\<\\n \\\\vspace{0.5cm} \\\\textbf{Varia\[CCedilla]\
\[OTilde]es:} \>\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"ScientificForm", "[", 
                    RowBox[{"Length", "[", "print", "]"}], "]"}], "]"}], 
                    "<>", "\"\<\\n \\\\vspace{0.5cm}\>\""}]}], "]"}]}], 
                 "]"}]}]}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";",
           "\[IndentingNewLine]", 
          RowBox[{"variacao3", "=", 
           RowBox[{"Evaluate", "[", 
            RowBox[{"variacao3", "*", "variacao4"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", "variacao3", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"prob", "=", 
           RowBox[{"ScientificForm", "[", 
            RowBox[{"N", "[", 
             RowBox[{
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"Product", "[", 
                 RowBox[{
                  RowBox[{"variacao3", "-", "i"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "1", ",", "1500"}], "}"}]}], "]"}], "/", 
                
                RowBox[{"Product", "[", 
                 RowBox[{"variacao3", ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "1", ",", "1500"}], "}"}]}], "]"}]}]}], 
              ",", "3"}], "]"}], "]"}]}], ";"}]}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"WriteString", "[", 
        RowBox[{"saidasl", ",", 
         RowBox[{
         "\"\<\\n \\\\vspace{0.5cm} \\\\hrule \\n \\\\vspace{0.2cm} \
\\\\textbf{N\[UAcute]mero Total de Quest\[OTilde]es:} $$\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ScientificForm", "[", "variacao", "]"}], "]"}], "]"}], 
          "<>", 
          "\"\<$$ \\n \\n \\\\textbf{N\[UAcute]mero Total de Varia\[CCedilla]\
\[OTilde]es:} $$\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ScientificForm", "[", "variacao2", "]"}], "]"}], "]"}], 
          "<>", "\"\<$$  \\n \\n \\\\textbf{N\[UAcute]mero de Provas \
Distintas:} $$\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"ReleaseHold", "[", 
            RowBox[{"TeXForm", "[", 
             RowBox[{"ScientificForm", "[", 
              RowBox[{"N", "[", 
               RowBox[{"variacao3", ",", "4"}], "]"}], "]"}], "]"}], "]"}], 
           "]"}], "<>", 
          "\"\<$$ \\n \\n \\\\textbf{Probabilidade de duas Provas Iguais \
(1500 alunos):} $$\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"TeXForm", "[", 
            RowBox[{"ScientificForm", "[", 
             RowBox[{"N", "[", 
              RowBox[{"prob", ",", "4"}], "]"}], "]"}], "]"}], "]"}], "<>", 
          "\"\<$$ \\\\vspace{0.2cm}\\\\hrule\\\\end{ExerciseList} \
\\\\end{multicols}\\\\end{document}\>\""}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Close", "[", "saidasl", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"SetDirectory", "[", 
        RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "]"}]}], 
   "\n", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.61040393031284*^9, 3.61040427904611*^9}, {
   3.610404315843944*^9, 3.610404370627762*^9}, {3.6104044453787317`*^9, 
   3.6104045144176807`*^9}, {3.610404566515251*^9, 3.6104045805922194`*^9}, {
   3.610404638696878*^9, 3.610404841156437*^9}, {3.61040498334123*^9, 
   3.6104049891207657`*^9}, {3.610405059727089*^9, 3.610405061577692*^9}, 
   3.6104051422739477`*^9, {3.610405178338828*^9, 3.6104052222289658`*^9}, {
   3.61040525833309*^9, 3.610405473792368*^9}, {3.610405649668404*^9, 
   3.610405721936831*^9}, {3.610405788635785*^9, 3.610405823078347*^9}, {
   3.61040587067948*^9, 3.6104059001646*^9}, {3.610807878099922*^9, 
   3.610807878754608*^9}, {3.610808947785499*^9, 3.6108089483864803`*^9}, {
   3.610820849339266*^9, 3.6108208504276953`*^9}, {3.610820894864444*^9, 
   3.610820900203629*^9}, {3.610820934072443*^9, 3.6108209364987497`*^9}, {
   3.610837582641984*^9, 3.610837608468857*^9}, {3.610837666033841*^9, 
   3.6108376774565496`*^9}, {3.610837824882174*^9, 3.6108378544874153`*^9}, {
   3.610838001014221*^9, 3.610838029679242*^9}, {3.61083823299778*^9, 
   3.61083823424669*^9}, 3.6108382760439053`*^9, {3.610838364435761*^9, 
   3.610838383928031*^9}, {3.610838532604064*^9, 3.610838552801955*^9}, {
   3.610838606446745*^9, 3.6108387312197027`*^9}, 3.610838803692625*^9, {
   3.610838855956544*^9, 3.610838858270533*^9}, {3.61083894020823*^9, 
   3.610838955948*^9}, {3.610839341456211*^9, 3.6108393429771214`*^9}, {
   3.6108394216799583`*^9, 3.6108394223834763`*^9}, {3.6108791362087593`*^9, 
   3.610879136505887*^9}, {3.6108835647715054`*^9, 3.610883567567973*^9}, {
   3.610889443348164*^9, 3.610889444394491*^9}, 3.610889476610413*^9, {
   3.610890473961156*^9, 3.610890488349057*^9}, 3.610890550047555*^9, {
   3.6108906468622437`*^9, 3.6108906479701643`*^9}, {3.6108906828014507`*^9, 
   3.6108907207584476`*^9}, {3.610890793589838*^9, 3.6108908411974773`*^9}, {
   3.6109008177036037`*^9, 3.610900818122251*^9}, {3.610900868184383*^9, 
   3.6109008687260323`*^9}, {3.610901085668612*^9, 3.610901120944536*^9}, {
   3.610901151680031*^9, 3.610901157690543*^9}, 3.610901263364259*^9, 
   3.610901305077421*^9, {3.610901378598036*^9, 3.610901431884865*^9}, {
   3.6109014670232983`*^9, 3.610901478484868*^9}, {3.610901579852367*^9, 
   3.610901589251712*^9}, {3.610901806663438*^9, 3.6109018413752813`*^9}, {
   3.610903044863649*^9, 3.610903060402341*^9}, {3.61090457531185*^9, 
   3.610904600282473*^9}, 3.610904638118393*^9, {3.610904697751294*^9, 
   3.610904710037862*^9}, {3.610905240613872*^9, 3.61090524204935*^9}, {
   3.6109056701903152`*^9, 3.6109056719856873`*^9}, {3.610905909139244*^9, 
   3.610905912503661*^9}, 3.6109061085344477`*^9, {3.610982347158904*^9, 
   3.6109824377590017`*^9}, {3.610982592974917*^9, 3.610982638007168*^9}, 
   3.610982718566325*^9, {3.6109827605949383`*^9, 3.610982770916793*^9}, {
   3.610982835767982*^9, 3.610982839641822*^9}, 3.611489393447363*^9, 
   3.612117324599761*^9, {3.6121244966271563`*^9, 3.612124502260605*^9}, {
   3.612132552290122*^9, 3.612132618314851*^9}, {3.612132659433248*^9, 
   3.6121326639322042`*^9}, {3.612132701615468*^9, 3.612133016913699*^9}, {
   3.612133071087562*^9, 3.612133073087143*^9}, {3.6121331913575583`*^9, 
   3.612133218199154*^9}, {3.612133277755321*^9, 3.612133285314888*^9}, 
   3.6121333825151243`*^9, {3.612133523697966*^9, 3.612133542415803*^9}, {
   3.612133635271545*^9, 3.612133644548473*^9}, {3.6121338134071627`*^9, 
   3.612133813928088*^9}, {3.6121339921658497`*^9, 3.612134022857265*^9}, 
   3.6121340959935923`*^9, {3.612134479696004*^9, 3.612134544161828*^9}, {
   3.6121346043022127`*^9, 3.6121347133307467`*^9}, {3.612134753178173*^9, 
   3.612134779030958*^9}, 3.612134813302647*^9, {3.612135292390973*^9, 
   3.6121353146359253`*^9}, {3.612135428628826*^9, 3.6121354608374023`*^9}, 
   3.612135493775907*^9, {3.612136228862088*^9, 3.612136246425014*^9}, {
   3.6121368257466917`*^9, 3.6121369152573853`*^9}, {3.612136960509028*^9, 
   3.612136962083765*^9}, {3.612137860065589*^9, 3.6121378635618668`*^9}, {
   3.612137898746746*^9, 3.612137929093357*^9}, {3.612138207050579*^9, 
   3.612138212925336*^9}, {3.6121389631769876`*^9, 3.612139069131146*^9}, {
   3.6121392393288107`*^9, 3.6121392474846163`*^9}, 3.612139618320697*^9, {
   3.612139828900518*^9, 3.6121398326479607`*^9}, {3.612139893534892*^9, 
   3.6121398940545397`*^9}, 3.612140419727129*^9, {3.61214247338732*^9, 
   3.6121424794456863`*^9}, 3.6121474610024014`*^9, 3.612148126289729*^9, {
   3.612148609516081*^9, 3.612148612134802*^9}, {3.612150555337873*^9, 
   3.612150574886861*^9}, {3.612153121900406*^9, 3.612153207640132*^9}, {
   3.6121867604566927`*^9, 3.612186777961047*^9}, {3.612187093048188*^9, 
   3.6121871226983232`*^9}, {3.61219103774736*^9, 3.612191143701229*^9}, {
   3.61219117914318*^9, 3.612191189239362*^9}, {3.612191274411181*^9, 
   3.612191283933383*^9}, {3.612191318678884*^9, 3.612191323697095*^9}, {
   3.612191409038522*^9, 3.612191471406578*^9}, {3.612191533672823*^9, 
   3.61219154028755*^9}, {3.612191665229958*^9, 3.6121916690102577`*^9}, {
   3.612191700463766*^9, 3.6121917013951607`*^9}, {3.612191766618436*^9, 
   3.612191781801446*^9}, {3.612195921151116*^9, 3.612195983730529*^9}, {
   3.6121962996014023`*^9, 3.612196309308585*^9}, {3.612196385487145*^9, 
   3.6121963878884087`*^9}, {3.612196467538136*^9, 3.612196482921446*^9}, {
   3.61219667969906*^9, 3.612196686022893*^9}, {3.612196729679098*^9, 
   3.612196777320465*^9}, {3.612199956577673*^9, 3.612200000497313*^9}, {
   3.6122086747868557`*^9, 3.612208696478938*^9}, {3.612209033481987*^9, 
   3.6122090706899*^9}, {3.612209130945059*^9, 3.6122091597386217`*^9}, {
   3.61220942493272*^9, 3.6122094364619083`*^9}, 3.61220946871402*^9, {
   3.6122095042894707`*^9, 3.612209507851223*^9}, {3.6122238990418673`*^9, 
   3.612223907594981*^9}, 3.612224370174828*^9, {3.612224636002233*^9, 
   3.612224640696517*^9}, {3.612309352431889*^9, 3.612309529494788*^9}, {
   3.6123095719799547`*^9, 3.612309602912635*^9}, 3.612309639108469*^9, {
   3.612309744423901*^9, 3.612309956349902*^9}, {3.612310004955711*^9, 
   3.612310041724163*^9}, {3.61231009172288*^9, 3.612310105497376*^9}, {
   3.612310282024334*^9, 3.612310297634782*^9}, {3.612310380545772*^9, 
   3.612310402050541*^9}, {3.6123104829761477`*^9, 3.6123105203183804`*^9}, {
   3.6123109807147017`*^9, 3.6123110290487843`*^9}, 3.612311076122395*^9, {
   3.612311258272912*^9, 3.612311261077038*^9}, {3.6123112939090023`*^9, 
   3.6123113071464787`*^9}, {3.612311353013213*^9, 3.612311373476663*^9}, {
   3.612311414680766*^9, 3.6123114168372803`*^9}, {3.612311582058507*^9, 
   3.612311603927648*^9}, 3.612311637476242*^9, 3.612311682552444*^9, {
   3.612311732816723*^9, 3.612311752227045*^9}, {3.612311851307083*^9, 
   3.61231187402594*^9}, 3.612312022040797*^9, {3.612312053946303*^9, 
   3.6123120551672688`*^9}, {3.6123120960273657`*^9, 3.61231213663021*^9}, 
   3.612312206368682*^9, {3.612312250935195*^9, 3.612312267686692*^9}, {
   3.6123123015281887`*^9, 3.6123123100667963`*^9}, 3.612312383930788*^9, {
   3.612312416955331*^9, 3.612312428168983*^9}, {3.612312578009777*^9, 
   3.612312585608816*^9}, {3.612312642090641*^9, 3.612312653166174*^9}, {
   3.612312694587462*^9, 3.6123126981749773`*^9}, {3.612312792005701*^9, 
   3.6123129090671167`*^9}, {3.612312952058963*^9, 3.6123129589970427`*^9}, {
   3.6123130363357286`*^9, 3.612313070711072*^9}, {3.612313134478304*^9, 
   3.61231316087364*^9}, {3.612313246934559*^9, 3.6123132956792507`*^9}, 
   3.6123133521860523`*^9, {3.6123133854414663`*^9, 3.612313385939887*^9}, {
   3.6123138815237207`*^9, 3.6123138825732117`*^9}, {3.612313914218959*^9, 
   3.612313935665511*^9}, {3.612313985208301*^9, 3.612314000929579*^9}, {
   3.612314038234235*^9, 3.612314075426499*^9}, {3.612314262050662*^9, 
   3.612314291694665*^9}, 3.6123547533648148`*^9, {3.6123548158149652`*^9, 
   3.612354816156369*^9}, {3.612355840005837*^9, 3.612355885331118*^9}, {
   3.612355924058361*^9, 3.6123559245893307`*^9}, {3.6123560493613*^9, 
   3.61235619404364*^9}, {3.612356245732053*^9, 3.612356273502489*^9}, {
   3.612356428574298*^9, 3.612356458330989*^9}, {3.612356612528193*^9, 
   3.6123566128576508`*^9}, {3.6123568107238398`*^9, 3.612356814667239*^9}, {
   3.6123568773952007`*^9, 3.612356887712818*^9}, {3.6123569864647913`*^9, 
   3.612356993420089*^9}, {3.6123570631968*^9, 3.612357126365987*^9}, {
   3.612357158876491*^9, 3.612357204576144*^9}, {3.612357252750523*^9, 
   3.6123573719998426`*^9}, {3.6123574292058887`*^9, 3.61235743857594*^9}, {
   3.612357563933485*^9, 3.6123576469211693`*^9}, {3.6123577384598093`*^9, 
   3.612357764782613*^9}, {3.612358058946046*^9, 3.612358061270177*^9}, 
   3.612358916859644*^9, {3.612392838179472*^9, 3.612392948910697*^9}, {
   3.612393215839902*^9, 3.6123932239599743`*^9}, 3.6123932572704973`*^9, {
   3.612393409950881*^9, 3.612393425733245*^9}, {3.612393505236205*^9, 
   3.612393522404132*^9}, {3.6123935643256893`*^9, 3.6123935806231813`*^9}, {
   3.612393619299914*^9, 3.612393620705277*^9}, {3.612393719960956*^9, 
   3.6123937433301477`*^9}, {3.612393828909211*^9, 3.612393893514289*^9}, {
   3.6123941751456203`*^9, 3.612394175731824*^9}, {3.61239430249559*^9, 
   3.612394328557548*^9}, {3.612394405742367*^9, 3.6123944842892942`*^9}, {
   3.612394602486434*^9, 3.612394604680079*^9}, {3.612394723027266*^9, 
   3.61239475211371*^9}, {3.612394846092388*^9, 3.612394902601666*^9}, {
   3.612394943378978*^9, 3.612394943818931*^9}, {3.612394993606345*^9, 
   3.612395032581257*^9}, {3.612395071896225*^9, 3.612395092871356*^9}, {
   3.612396785520466*^9, 3.612396788243944*^9}, 3.614376280128408*^9, {
   3.6152889515720673`*^9, 3.615288958901613*^9}, 3.615293320585533*^9, {
   3.62056892841343*^9, 3.6205689287586613`*^9}, {3.620569133239995*^9, 
   3.620569160797967*^9}, {3.6205692091961527`*^9, 3.6205692105938396`*^9}, {
   3.620569259629142*^9, 3.620569261470912*^9}, {3.6205696254367437`*^9, 
   3.620569669028823*^9}, {3.620569951273419*^9, 3.620569956292468*^9}, {
   3.620570159870721*^9, 3.620570168509006*^9}, {3.6205704010419292`*^9, 
   3.6205704539404297`*^9}, {3.6205706125407143`*^9, 
   3.6205706496492453`*^9}, {3.620571151190014*^9, 3.620571152920662*^9}, 
   3.6205714226711893`*^9, {3.620571549833353*^9, 3.620571550306131*^9}, {
   3.620571744625606*^9, 3.6205717711341887`*^9}, {3.62057180992161*^9, 
   3.62057181313097*^9}, {3.6205718492434673`*^9, 3.620571867040687*^9}, {
   3.620572026193475*^9, 3.620572030427038*^9}, {3.62059910284367*^9, 
   3.620599113813983*^9}, {3.620599144933305*^9, 3.620599145908861*^9}, {
   3.62060031794*^9, 3.620600327679821*^9}, {3.6206451340691442`*^9, 
   3.620645135585416*^9}, {3.620661131359219*^9, 3.620661207308803*^9}, {
   3.620661256439889*^9, 3.620661256727119*^9}, {3.620675806651519*^9, 
   3.620675809615787*^9}, {3.6206760754171467`*^9, 3.6206760772021713`*^9}, {
   3.6206762226189337`*^9, 3.620676230638135*^9}, {3.620676388819887*^9, 
   3.620676389008165*^9}, {3.620677247553018*^9, 3.62067724926639*^9}, {
   3.6215304338844833`*^9, 3.621530435116048*^9}, {3.62153047946284*^9, 
   3.621530482359014*^9}, {3.621530513603705*^9, 3.62153051397104*^9}, {
   3.621530838476202*^9, 3.621530840124976*^9}, {3.621531041344401*^9, 
   3.621531069734186*^9}, {3.621531278707571*^9, 3.621531290007738*^9}, {
   3.6215320843500843`*^9, 3.621532088364439*^9}, {3.6223881611689672`*^9, 
   3.6223881614278927`*^9}, {3.622885792233406*^9, 3.6228857951606503`*^9}, {
   3.622885837006707*^9, 3.6228858602982483`*^9}, {3.623066570168536*^9, 
   3.623066570416306*^9}, {3.623066649019685*^9, 3.623066649266296*^9}, {
   3.623497540495184*^9, 3.623497565598353*^9}, {3.623511255342822*^9, 
   3.623511259179093*^9}, {3.6235113382009363`*^9, 3.623511343112967*^9}, {
   3.623519327920514*^9, 3.62351933581665*^9}, 3.6235194023894167`*^9, {
   3.6235195071349697`*^9, 3.623519508915503*^9}, {3.62353077569916*^9, 
   3.623530797064616*^9}, {3.623531444970668*^9, 3.6235314561966248`*^9}, {
   3.626205032814653*^9, 3.626205033527987*^9}, {3.651847625780274*^9, 
   3.651847626269876*^9}, {3.6518477212622023`*^9, 3.651847724421626*^9}, {
   3.652449363979013*^9, 3.6524493667399397`*^9}, {3.653244593094351*^9, 
   3.653244593488381*^9}, {3.653694697579639*^9, 3.653694698129356*^9}, {
   3.654285003039227*^9, 3.654285003512398*^9}, {3.65452563601816*^9, 
   3.6545256479228*^9}, {3.655029035985148*^9, 3.6550290362088842`*^9}, {
   3.656518384678844*^9, 3.656518387742988*^9}, {3.656524125340211*^9, 
   3.656524151602059*^9}, 3.656524188631695*^9, {3.683567287161441*^9, 
   3.6835672888512278`*^9}, {3.6842339765024157`*^9, 3.68423398286766*^9}, {
   3.684234200075922*^9, 3.684234207876913*^9}, {3.684599677439372*^9, 
   3.684599681143776*^9}, {3.684927524494548*^9, 3.6849275249976873`*^9}, {
   3.728344573117343*^9, 3.728344574259359*^9}, {3.7399771098648233`*^9, 
   3.739977111357688*^9}, {3.739977487723428*^9, 3.739977516852578*^9}, {
   3.7399776020684032`*^9, 3.7399776363307056`*^9}, {3.7399780598271723`*^9, 
   3.7399780771143923`*^9}, {3.740412590257106*^9, 3.740412592813037*^9}, {
   3.74240789517246*^9, 3.742407909780941*^9}, {3.742408454907469*^9, 
   3.742408474671924*^9}, {3.7424119405201283`*^9, 3.74241195057131*^9}, {
   3.742414520758545*^9, 3.7424145238630123`*^9}, {3.742483583264255*^9, 
   3.742483583566935*^9}, {3.745501319919199*^9, 3.745501322830456*^9}, {
   3.7474240861796513`*^9, 3.7474240872629223`*^9}, 3.748106048915732*^9, {
   3.749068635736507*^9, 3.749068636295555*^9}, {3.749732095630619*^9, 
   3.749732100469819*^9}, 3.749749089111533*^9, {3.7499275429079313`*^9, 
   3.749927564271789*^9}, {3.749927693809669*^9, 3.749927720713036*^9}, 
   3.750601619067384*^9, {3.751561946489955*^9, 3.75156194706074*^9}, {
   3.751998765401342*^9, 3.7519987661991873`*^9}, 3.8007941151097813`*^9, {
   3.800794219079706*^9, 3.800794244647924*^9}, {3.80316371478053*^9, 
   3.803163720980699*^9}},
 CellLabel->"In[96]:=",ExpressionUUID->"7089d5e1-b716-4483-9bbd-c76a98adec92"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportaLatex2", "[", "\"\<Lista0\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.800794181183626*^9, 3.800794186714796*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"880c915e-ee50-41e6-8be0-97645295282b"],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{3.800794187962665*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"cff297c4-2e95-4077-86d7-2ad910557a65"],

Cell[BoxData["7"], "Print",
 CellChangeTimes->{3.8007941881858597`*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"0b5c38ba-3950-4962-b8ad-fbe6dd7c35ba"],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{3.800794188189755*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"2fa5766a-f298-4fe9-94a3-390f475613a8"],

Cell[BoxData["210"], "Print",
 CellChangeTimes->{3.800794189150667*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"40d004bc-cfba-4f37-84c8-3e34c521f575"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1366, 706},
WindowMargins->{{0, Automatic}, {0, Automatic}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 55129, 1264, 8385, "Input",ExpressionUUID->"ad751863-6487-4d15-b3bc-8327a4ee9dd7",
 InitializationCell->True],
Cell[55690, 1286, 267, 4, 55, "Input",ExpressionUUID->"baff8bbd-f208-4208-8629-8b7083a401dc"],
Cell[CellGroupData[{
Cell[55982, 1294, 307, 5, 68, "Section",ExpressionUUID->"1ed2ee8e-082a-4d3d-9b63-70bdd99d711f"],
Cell[CellGroupData[{
Cell[56314, 1303, 10395, 143, 78, "Input",ExpressionUUID->"b7846c49-82f9-4fe7-9c5e-f5ec0394780d"],
Cell[CellGroupData[{
Cell[66734, 1450, 364, 7, 25, "Print",ExpressionUUID->"7b109075-2b74-4f6a-8347-33fb80a10055"],
Cell[67101, 1459, 364, 7, 25, "Print",ExpressionUUID->"eec5ae15-98de-44c8-b402-c9c86e9af684"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67526, 1473, 465, 7, 68, "Section",ExpressionUUID->"745f3e89-8551-4c2a-8b7d-c34c2bcdad65"],
Cell[CellGroupData[{
Cell[68016, 1484, 14179, 195, 78, "Input",ExpressionUUID->"2e07a7f7-42f3-44d7-ac57-69f7e3d4cc8c"],
Cell[CellGroupData[{
Cell[82220, 1683, 293, 6, 25, "Print",ExpressionUUID->"816b2468-706f-411c-8580-f7f13b5d5f7b"],
Cell[82516, 1691, 295, 6, 25, "Print",ExpressionUUID->"0ec64000-81e4-44bb-a3db-b52cd28d431c"],
Cell[82814, 1699, 293, 6, 25, "Print",ExpressionUUID->"f786f1b3-db82-4bd3-bad2-79dd1d795cf2"],
Cell[83110, 1707, 295, 6, 25, "Print",ExpressionUUID->"331303fa-8383-4416-83ef-97a2be99804d"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83466, 1720, 216, 4, 99, "Title",ExpressionUUID->"ab1a0d28-0037-408c-8840-b8109e1731a2"],
Cell[83685, 1726, 379, 7, 36, "Text",ExpressionUUID->"81d381dd-23dc-49df-923d-0806fae5e193"],
Cell[CellGroupData[{
Cell[84089, 1737, 221, 4, 31, "Input",ExpressionUUID->"e558a741-c4a6-4058-9c9d-d06449784eea"],
Cell[84313, 1743, 200, 4, 35, "Output",ExpressionUUID->"bbdfa53e-081d-45d8-9071-bbf04f2f4bfa"]
}, Open  ]],
Cell[84528, 1750, 25480, 434, 2231, "Input",ExpressionUUID->"7089d5e1-b716-4483-9bbd-c76a98adec92"],
Cell[CellGroupData[{
Cell[110033, 2188, 228, 4, 31, "Input",ExpressionUUID->"880c915e-ee50-41e6-8be0-97645295282b"],
Cell[CellGroupData[{
Cell[110286, 2196, 174, 4, 25, "Print",ExpressionUUID->"cff297c4-2e95-4077-86d7-2ad910557a65"],
Cell[110463, 2202, 176, 4, 25, "Print",ExpressionUUID->"0b5c38ba-3950-4962-b8ad-fbe6dd7c35ba"],
Cell[110642, 2208, 174, 4, 25, "Print",ExpressionUUID->"2fa5766a-f298-4fe9-94a3-390f475613a8"],
Cell[110819, 2214, 176, 4, 25, "Print",ExpressionUUID->"40d004bc-cfba-4f37-84c8-3e34c521f575"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

